/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container;

import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ContainerHolder<T> {
    private final T object;

    public boolean contains() {
        return this.object != null;
    }

    @Nullable
    public T getOrNull() {
        return this.object;
    }

    @Nullable
    public <R> R supplyOrNull(@NonNull Function<T, R> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return this.object != null ? (R)function.apply(this.object) : null;
    }

    public void runOrNull(Consumer<T> consumer) {
        if (this.object != null) {
            consumer.accept(this.object);
        }
    }

    public ContainerHolder(T object) {
        this.object = object;
    }
}

