/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.binder;

import info.cho.passwords.fairy.container.binder.ContainerObjectBinder;
import info.cho.passwords.fairy.container.object.ContainerObj;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class ContainerObjectBinderImpl
implements ContainerObjectBinder {
    private final Map<Class<?>, ContainerObj> bindings = new ConcurrentHashMap();

    @Override
    @Nullable
    public ContainerObj getBinding(Class<?> type) {
        ContainerObj obj = this.bindings.get(type);
        if (obj == null) {
            obj = this.findBindingAssignableByType(type);
        }
        return obj;
    }

    @Override
    @Nullable
    public ContainerObj getExactBinding(Class<?> classType) {
        return this.bindings.get(classType);
    }

    private ContainerObj findBindingAssignableByType(Class<?> type) {
        for (ContainerObj value : this.bindings.values()) {
            Class<?> valueType = value.getType();
            if (!type.isAssignableFrom(valueType)) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean isBound(Class<?> type) {
        return this.getBinding(type) != null;
    }

    @Override
    public void bind(Class<?> type, ContainerObj object) {
        this.bindings.put(type, object);
    }

    @Override
    public void unbind(Class<?> type) {
        this.bindings.remove(type);
    }
}

