/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.node.destroyer;

import info.cho.passwords.fairy.container.ContainerContext;
import info.cho.passwords.fairy.container.node.ContainerNode;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.container.processor.ContainerObjDestroyProcessor;

public class ContainerNodeDestroyer {
    private final ContainerContext context;

    public void destroy(ContainerNode node) {
        node.graph().forEachCounterClockwise(this::handlePreDestroy);
        node.graph().forEachCounterClockwise(this::handlePostDestroy);
        for (ContainerNode child : node.childs()) {
            this.context.nodeDestroyer().destroy(child);
        }
    }

    private void handlePreDestroy(ContainerObj object) {
        this.callPreDestroyProcessor(object);
    }

    private void callPreDestroyProcessor(ContainerObj object) {
        if (!object.isSingletonScope()) {
            return;
        }
        Object instance = this.context.singletonObjectRegistry().getSingleton(object.getType());
        if (instance == null) {
            return;
        }
        for (ContainerObjDestroyProcessor destroyProcessor : this.context.destroyProcessors()) {
            destroyProcessor.processPreDestroy(object, instance);
        }
    }

    private void handlePostDestroy(ContainerObj object) {
        this.callPostDestroyProcessor(object);
        Class<?> type = object.getType();
        this.context.containerObjectBinder().unbind(type);
        this.context.objectCollectorRegistry().removeFromCollectors(object);
        this.context.singletonObjectRegistry().removeSingleton(type);
    }

    private void callPostDestroyProcessor(ContainerObj object) {
        if (!object.isSingletonScope()) {
            return;
        }
        Object instance = this.context.singletonObjectRegistry().getSingleton(object.getType());
        if (instance == null) {
            return;
        }
        for (ContainerObjDestroyProcessor destroyProcessor : this.context.destroyProcessors()) {
            destroyProcessor.processPostDestroy(object, instance);
        }
    }

    public ContainerNodeDestroyer(ContainerContext context) {
        this.context = context;
    }
}

