/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.node.loader;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.Fairy;
import info.cho.passwords.fairy.container.ContainerContext;
import info.cho.passwords.fairy.container.node.ContainerNode;
import info.cho.passwords.fairy.container.node.scanner.ContainerNodeClassScanner;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.plugin.Plugin;
import info.cho.passwords.fairy.util.Stacktrace;
import java.util.ArrayList;
import java.util.List;

public class PluginNodeLoader {
    private final ContainerContext context;
    private final Plugin plugin;
    private ContainerNode node;

    public ContainerNode load() {
        this.node = ContainerNode.create(this.plugin.getName(), this.context.containerObjectBinder());
        this.addPluginAsComponent();
        this.runClassScanner();
        this.loadNode();
        return this.node;
    }

    private boolean loadNode() {
        return this.context.loadContainerNode(this.node);
    }

    private void addPluginAsComponent() {
        Class<?> pluginClass = this.plugin.getClass();
        ContainerObj pluginObj = ContainerObj.create(pluginClass);
        this.context.singletonObjectRegistry().registerSingleton(pluginClass, this.plugin);
        this.context.containerObjectBinder().bind(pluginClass, pluginObj);
        this.node.addObj(pluginObj);
        Debug.log("Plugin " + this.plugin.getName() + " has been registered as ContainerObject.", new Object[0]);
    }

    private void runClassScanner() {
        try {
            ContainerNodeClassScanner classScanner = new ContainerNodeClassScanner(this.context, this.context.containerObjectBinder(), this.plugin.getName(), this.node);
            classScanner.getClassPaths().addAll(this.findClassPaths());
            classScanner.getExcludedClassPaths().add(Fairy.getFairyPackage());
            classScanner.getClassLoaders().addAll(this.plugin.getClassLoaderRegistry().getClassLoaders());
            classScanner.getUrls().addAll(this.plugin.getClassLoaderRegistry().getUrls());
            classScanner.scan();
        }
        catch (Throwable throwable) {
            Log.error("Error while scanning classes for framework", Stacktrace.simplifyStacktrace(throwable), new Object[0]);
            Fairy.getPlatform().shutdown();
        }
    }

    private List<String> findClassPaths() {
        ArrayList<String> classPaths = new ArrayList<String>(this.context.findClassPaths(this.plugin.getClass()));
        classPaths.add(this.plugin.getDescription().getShadedPackage());
        return classPaths;
    }

    public PluginNodeLoader(ContainerContext context, Plugin plugin) {
        this.context = context;
        this.plugin = plugin;
    }
}

