/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.object.resolver;

import info.cho.passwords.fairy.container.binder.ContainerObjectBinder;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.container.object.resolver.ContainerObjectFactory;
import info.cho.passwords.fairy.container.object.resolver.ContainerObjectResolver;
import info.cho.passwords.fairy.util.ConditionUtils;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class ContainerObjectResolverImpl
implements ContainerObjectResolver {
    private final ContainerObjectBinder binder;
    private final ContainerObjectFactory singletonObjectFactory;
    private final ContainerObjectFactory prototypeObjectFactory;

    @Override
    @NotNull
    public CompletableFuture<Object[]> resolveInstances(@NotNull Class<?>[] types) throws Exception {
        Object[] args = new Object[types.length];
        CompletableFuture[] futures = new CompletableFuture[types.length];
        for (int i = 0; i < args.length; ++i) {
            Class<?> type = types[i];
            int index = i;
            futures[i] = this.resolveInstance(type).thenAccept(instance -> {
                args[index] = instance;
            });
        }
        return CompletableFuture.allOf(futures).thenApply($ -> args);
    }

    @Override
    @NotNull
    public CompletableFuture<Object> resolveInstance(@NotNull Class<?> type) throws Exception {
        CompletableFuture<Object> future;
        ContainerObj object = this.binder.getBinding(type);
        ConditionUtils.notNull(object, String.format("Couldn't find container object %s!", type.getName()));
        switch (object.getScope()) {
            case SINGLETON: {
                future = this.singletonObjectFactory.createInstance(object.getType());
                break;
            }
            case PROTOTYPE: {
                future = this.prototypeObjectFactory.createInstance(object.getType());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)object.getScope()));
            }
        }
        return future;
    }

    public ContainerObjectResolverImpl(ContainerObjectBinder binder, ContainerObjectFactory singletonObjectFactory, ContainerObjectFactory prototypeObjectFactory) {
        this.binder = binder;
        this.singletonObjectFactory = singletonObjectFactory;
        this.prototypeObjectFactory = prototypeObjectFactory;
    }
}

