/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.processor.injection;

import info.cho.passwords.fairy.container.Autowired;
import info.cho.passwords.fairy.container.node.ContainerNode;
import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.container.object.resolver.ContainerObjectResolver;
import info.cho.passwords.fairy.container.processor.ContainerNodeClassScanProcessor;
import info.cho.passwords.fairy.container.processor.ContainerNodeInitProcessor;
import info.cho.passwords.fairy.container.processor.ContainerObjInitProcessor;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.AsyncUtils;
import info.cho.passwords.fairy.util.ClassGraphUtil;
import info.cho.passwords.fairy.util.Utility;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class AutowiredAnnotationProcessor
implements ContainerObjInitProcessor,
ContainerNodeClassScanProcessor,
ContainerNodeInitProcessor {
    private final Map<String, NodeContext> nodes = new ConcurrentHashMap<String, NodeContext>();

    @Override
    public CompletableFuture<?> processPreInitialization(ContainerObj object, Object instance, ContainerObjectResolver resolver) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList futures = new ArrayList();
        for (Class<?> superClass : Utility.getSuperClasses(instance.getClass())) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            Autowired annotation = field.getAnnotation(Autowired.class);
            if (annotation == null || Modifier.isStatic(modifiers)) continue;
            if (Modifier.isFinal(modifiers)) {
                throw new IllegalStateException("The field " + field + " is final but marked @Autowired");
            }
            try {
                futures.add(this.injectAutowiredField(field, instance, resolver));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to inject field " + field, ex);
            }
        }
        return AsyncUtils.allOf(futures);
    }

    @Override
    public void processClassScan(ContainerNode node, ScanResult scanResult) {
        NodeContext context = this.nodes.computeIfAbsent(node.name(), key -> new NodeContext());
        ClassGraphUtil.fieldWithAnnotation(scanResult, Autowired.class).filter(field -> Modifier.isStatic(field.getModifiers())).forEach(context::addStaticField);
    }

    @Override
    public void processNodePreInitialization(ContainerNode node, ContainerObjectResolver containerObjectResolver) {
        NodeContext context = this.nodes.get(node.name());
        if (context != null) {
            context.injectStaticFields(containerObjectResolver);
        }
    }

    public CompletableFuture<?> injectAutowiredField(Field field, Object fieldInstance, ContainerObjectResolver resolver) throws Exception {
        Class<?> type = field.getType();
        CompletableFuture<Object> future = resolver.resolveInstance(type);
        return future.thenAccept(instance -> {
            try {
                AccessUtil.setAccessible(field);
                field.set(fieldInstance, instance);
            }
            catch (Exception ex) {
                Log.error("Failed to set field %s", field, ex);
            }
        });
    }

    private class NodeContext {
        private final List<Field> staticFields = new ArrayList<Field>();

        private NodeContext() {
        }

        public void addStaticField(Field field) {
            this.staticFields.add(field);
        }

        public void injectStaticFields(ContainerObjectResolver containerObjectResolver) {
            for (Field field : this.staticFields) {
                try {
                    AutowiredAnnotationProcessor.this.injectAutowiredField(field, null, containerObjectResolver);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to inject static field " + field, ex);
                }
            }
        }
    }
}

