/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.container.processor.injection;

import info.cho.passwords.fairy.container.object.ContainerObj;
import info.cho.passwords.fairy.container.processor.ContainerObjDestroyProcessor;
import info.cho.passwords.fairy.container.processor.ContainerObjInitProcessor;
import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.event.Event;
import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.event.EventSubscribeRegistry;
import info.cho.passwords.fairy.event.GlobalEventNode;
import info.cho.passwords.fairy.util.AsyncUtils;
import java.util.concurrent.CompletableFuture;

public class SubscribeEventAnnotationProcessor
implements ContainerObjInitProcessor,
ContainerObjDestroyProcessor {
    private static final MetaKey<EventNode> KEY = MetaKey.create("fairy:event-node", EventNode.class);

    @Override
    public CompletableFuture<?> processPostInitialization(ContainerObj object, Object instance) {
        if (!object.isSingletonScope()) {
            return AsyncUtils.empty();
        }
        EventNode<? extends Event> eventNode = EventSubscribeRegistry.create(instance);
        if (eventNode != null) {
            GlobalEventNode.get().addChild(eventNode);
            object.getMetadata().put(KEY, eventNode);
        }
        return AsyncUtils.empty();
    }

    @Override
    public void processPreDestroy(ContainerObj object, Object instance) {
        object.getMetadata().ifPresent(KEY, eventNode -> GlobalEventNode.get().removeChild((EventNode<Event>)eventNode));
    }
}

