/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.data;

import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.data.impl.MetaStorageImpl;
import java.lang.ref.Reference;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MetaStorage {
    default public boolean contains(@NotNull MetaKey<?> key) {
        return this.getOrNull(key) != null;
    }

    default public <T> Optional<T> get(@NotNull MetaKey<T> key) {
        return Optional.ofNullable(this.getOrNull(key));
    }

    @Nullable
    public <T> T getOrNull(@NotNull MetaKey<T> var1);

    @NotNull
    default public <T> T getOrDefault(@NotNull MetaKey<T> key, @NotNull T def) {
        T value = this.getOrNull(key);
        return value != null ? value : def;
    }

    @NotNull
    default public <T> T getOrThrow(@NotNull MetaKey<T> key) {
        T value = this.getOrNull(key);
        if (value == null) {
            throw new NullPointerException("No value found for key: " + key.getName());
        }
        return value;
    }

    public <T> void put(@NotNull MetaKey<T> var1, @NotNull T var2);

    public <T> void putRef(@NotNull MetaKey<T> var1, @NotNull Reference<T> var2);

    public <T> T computeIfAbsent(@NotNull MetaKey<T> var1, @NotNull Supplier<T> var2);

    public <T> void computeIfAbsentRef(@NotNull MetaKey<T> var1, @NotNull Supplier<Reference<T>> var2);

    default public <T> void ifPresent(@NotNull MetaKey<T> key, @NotNull Consumer<T> consumer) {
        T value = this.getOrNull(key);
        if (value != null) {
            consumer.accept(value);
        }
    }

    public <T> boolean remove(@NotNull MetaKey<T> var1);

    public void clear();

    public static MetaStorage create() {
        return new MetaStorageImpl();
    }
}

