/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.data.impl;

import info.cho.passwords.fairy.data.MetaKey;
import info.cho.passwords.fairy.data.MetaStorage;
import java.lang.ref.Reference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaStorageImpl
implements MetaStorage {
    private static final int BUCKET_SIZE = 8;
    private final StampedLock[] buckets = new StampedLock[8];
    private volatile Object[] data = new Object[MetaKey.getCurrentCapacity()];

    public MetaStorageImpl() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new StampedLock();
        }
    }

    private long[] lockAll() {
        long[] stamps = new long[this.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            stamps[i] = this.buckets[i].writeLock();
        }
        return stamps;
    }

    private void unlockAll(long[] stamps) {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].unlockWrite(stamps[i]);
        }
    }

    protected StampedLock getBucket(int key) {
        int hash = Integer.hashCode(key);
        return this.buckets[this.getBucketCheckMinValue(hash)];
    }

    private int getBucketCheckMinValue(int hash) {
        return Math.abs(hash == Integer.MIN_VALUE ? 0 : hash) % 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCapacity(int id) {
        if (id >= this.data.length) {
            long[] stamps = this.lockAll();
            try {
                if (id >= this.data.length) {
                    int newSize = Math.max(this.data.length * 2, id + 1);
                    Object[] newData = new Object[newSize];
                    System.arraycopy(this.data, 0, newData, 0, this.data.length);
                    this.data = newData;
                }
            }
            finally {
                this.unlockAll(stamps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getOrNull(@NotNull MetaKey<T> key) {
        StampedLock bucket = this.getBucket(key.getId());
        long stamp = bucket.tryOptimisticRead();
        T retVal = this.getOrNullInternal(key);
        if (bucket.validate(stamp)) {
            return key.cast(retVal);
        }
        stamp = bucket.readLock();
        try {
            T t = this.getOrNullInternal(key);
            return t;
        }
        finally {
            bucket.unlockRead(stamp);
        }
    }

    @Nullable
    private <T> T getOrNullInternal(@NotNull MetaKey<T> key) {
        if (key.getId() >= this.data.length) {
            return null;
        }
        Object object = this.data[key.getId()];
        return key.cast(object);
    }

    @Override
    public <T> void put(@NotNull MetaKey<T> key, @NotNull T value) {
        this.putInternal(key, value);
    }

    @Override
    public <T> void putRef(@NotNull MetaKey<T> key, @NotNull Reference<T> reference) {
        this.putInternal(key, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInternal(@NotNull MetaKey<?> key, @NotNull Object value) {
        this.ensureCapacity(key.getId());
        StampedLock bucket = this.getBucket(key.getId());
        long stamp = bucket.writeLock();
        try {
            this.data[key.getId()] = value;
        }
        finally {
            bucket.unlockWrite(stamp);
        }
    }

    @Override
    public <T> T computeIfAbsent(@NotNull MetaKey<T> key, @NotNull Supplier<T> value) {
        return key.cast(this.putIfAbsentInternal(key, value));
    }

    @Override
    public <T> void computeIfAbsentRef(@NotNull MetaKey<T> key, @NotNull Supplier<Reference<T>> reference) {
        this.putIfAbsentInternal(key, reference);
    }

    private Object putIfAbsentInternal(@NotNull MetaKey<?> key, @NotNull Supplier<?> value) {
        this.ensureCapacity(key.getId());
        StampedLock bucket = this.getBucket(key.getId());
        long stamp = bucket.tryOptimisticRead();
        boolean write = false;
        try {
            while (true) {
                if (stamp != 0L) {
                    Object object = this.data[key.getId()];
                    if (bucket.validate(stamp)) {
                        if (object != null) {
                            Object object2 = object;
                            return object2;
                        }
                        if ((stamp = bucket.tryConvertToWriteLock(stamp)) != 0L) {
                            write = true;
                            Object o = value.get();
                            this.data[key.getId()] = o;
                            Object obj = o;
                            return obj;
                        }
                    }
                }
                stamp = bucket.writeLock();
                write = true;
            }
        }
        finally {
            if (write) {
                bucket.unlock(stamp);
            }
        }
    }

    @Override
    public <T> boolean remove(@NotNull MetaKey<T> key) {
        StampedLock bucket = this.getBucket(key.getId());
        long stamp = bucket.tryOptimisticRead();
        boolean write = false;
        try {
            while (true) {
                if (stamp != 0L) {
                    boolean noRemoval;
                    boolean bl = noRemoval = key.getId() >= this.data.length || this.data[key.getId()] == null;
                    if (bucket.validate(stamp)) {
                        if (noRemoval) {
                            boolean bl2 = false;
                            return bl2;
                        }
                        if ((stamp = bucket.tryConvertToWriteLock(stamp)) != 0L) {
                            write = true;
                            this.data[key.getId()] = null;
                            boolean bl3 = true;
                            return bl3;
                        }
                    }
                }
                stamp = bucket.writeLock();
                write = true;
            }
        }
        finally {
            if (write) {
                bucket.unlock(stamp);
            }
        }
    }

    @Override
    public void clear() {
        long[] stamps = this.lockAll();
        try {
            this.data = new Object[MetaKey.getCurrentCapacity()];
        }
        finally {
            this.unlockAll(stamps);
        }
    }
}

