/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.data.impl.collection;

import info.cho.passwords.fairy.data.MetaStorage;
import info.cho.passwords.fairy.data.impl.MetaKeyImpl;
import info.cho.passwords.fairy.util.TypeLiteral;
import java.util.Collection;

public abstract class MetaCollectionKey<K, C extends Collection<K>>
extends MetaKeyImpl<C> {
    public MetaCollectionKey(String name, TypeLiteral<C> type) {
        super(name, type);
    }

    public abstract C createCollection();

    public C getCollection(MetaStorage storage) {
        return (C)((Collection)this.cast(storage.computeIfAbsent(this, this::createCollection)));
    }

    public boolean add(MetaStorage storage, K value) {
        return this.getCollection(storage).add(value);
    }

    public boolean remove(MetaStorage storage, K value) {
        return this.getCollection(storage).remove(value);
    }

    public boolean contains(MetaStorage storage, K value) {
        return this.getCollection(storage).contains(value);
    }

    public void clear(MetaStorage storage) {
        storage.remove(this);
    }

    public int size(MetaStorage storage) {
        return this.getCollection(storage).size();
    }

    public boolean isEmpty(MetaStorage storage) {
        return !storage.contains(this) || this.getCollection(storage).isEmpty();
    }

    public boolean containsAll(MetaStorage storage, Collection<K> values) {
        return storage.contains(this) && this.getCollection(storage).containsAll(values);
    }

    public void addAll(MetaStorage storage, Collection<K> values) {
        this.getCollection(storage).addAll(values);
    }

    public void removeAll(MetaStorage storage, Collection<K> values) {
        this.getCollection(storage).removeAll(values);
    }

    public void retainAll(MetaStorage storage, Collection<K> values) {
        this.getCollection(storage).retainAll(values);
    }

    public Collection<K> getValues(MetaStorage storage) {
        return this.getCollection(storage);
    }

    public void setValues(MetaStorage storage, Collection<K> values) {
        this.getCollection(storage).clear();
        this.getCollection(storage).addAll(values);
    }
}

