/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.event;

import info.cho.passwords.fairy.event.EventFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface EventBinding<E> {
    @NotNull
    public static <E, T> FilteredBuilder<E, T> filtered(@NotNull EventFilter<E, T> filter, @NotNull Predicate<T> predicate) {
        return new FilteredBuilder<E, T>(filter, predicate);
    }

    @NotNull
    public Collection<Class<?>> eventTypes();

    @NotNull
    public @NotNull Consumer<@NotNull E> consumer(@NotNull Class<?> var1);

    public static class FilteredBuilder<E, T> {
        private final EventFilter<E, T> filter;
        private final Predicate<T> predicate;
        private final Map<Class<?>, BiConsumer<Object, E>> mapped = new HashMap();

        FilteredBuilder(EventFilter<E, T> filter, Predicate<T> predicate) {
            this.filter = filter;
            this.predicate = predicate;
        }

        public <M extends E> FilteredBuilder<E, T> map(@NotNull Class<M> eventType, @NotNull @NotNull BiConsumer<@NotNull T, @NotNull M> consumer) {
            this.mapped.put(eventType, consumer);
            return this;
        }

        @NotNull
        public EventBinding<E> build() {
            HashMap copy = new HashMap(this.mapped);
            final Set eventTypes = copy.keySet();
            final HashMap<Class, Consumer<Object>> consumers = new HashMap<Class, Consumer<Object>>(eventTypes.size());
            for (Class eventType : eventTypes) {
                BiConsumer consumer = (BiConsumer)copy.get(eventType);
                consumers.put(eventType, event -> {
                    T handler = this.filter.getHandler(event);
                    if (!this.predicate.test(handler)) {
                        return;
                    }
                    consumer.accept(handler, event);
                });
            }
            return new EventBinding<E>(){

                @Override
                @NotNull
                public Collection<Class<?>> eventTypes() {
                    return eventTypes;
                }

                @Override
                @NotNull
                public Consumer<E> consumer(@NotNull Class<?> eventType) {
                    return (Consumer)consumers.get(eventType);
                }
            };
        }
    }
}

