/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.library;

import info.cho.passwords.fairy.FairyPlatform;
import info.cho.passwords.fairy.library.Library;
import info.cho.passwords.fairy.library.LibraryHandler;
import info.cho.passwords.fairy.library.LibraryHandlerPluginListener;
import info.cho.passwords.fairy.library.classloader.IsolatedClassLoader;
import info.cho.passwords.fairy.library.relocate.Relocation;
import info.cho.passwords.fairy.library.relocate.RelocationHandler;
import info.cho.passwords.fairy.library.relocate.RelocationHandlerImpl;
import info.cho.passwords.fairy.plugin.Plugin;
import info.cho.passwords.fairy.plugin.PluginManager;
import info.cho.passwords.fairy.util.URLClassLoaderAccess;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LibraryHandlerImpl
implements LibraryHandler {
    private final FairyPlatform platform;
    private final Path directory;
    private final MessageDigest messageDigest;
    private final Map<Library, Path> loadedLibrary;
    private final Map<Plugin, URLClassLoaderAccess> pluginClassLoaders;
    private final Map<Set<Library>, IsolatedClassLoader> loaders;
    private final RelocationHandler relocationHandler;

    public LibraryHandlerImpl(FairyPlatform platform) {
        this.platform = platform;
        this.directory = platform.getDataFolder().toPath().resolve("libs");
        this.loadedLibrary = new ConcurrentHashMap<Library, Path>();
        this.pluginClassLoaders = new ConcurrentHashMap<Plugin, URLClassLoaderAccess>();
        this.loaders = new ConcurrentHashMap<Set<Library>, IsolatedClassLoader>();
        try {
            if (!Files.exists(this.directory, new LinkOption[0])) {
                Files.createDirectories(this.directory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory for libraries.", e);
        }
        this.relocationHandler = new RelocationHandlerImpl(this);
        try {
            this.messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize message digest.", e);
        }
        if (PluginManager.isInitialized()) {
            PluginManager.INSTANCE.registerListener(new LibraryHandlerPluginListener(this));
        }
    }

    public Map<Plugin, URLClassLoaderAccess> getPluginClassLoaders() {
        return this.pluginClassLoaders;
    }

    protected void addClassLoader(Plugin plugin, URLClassLoaderAccess classLoader) {
        this.pluginClassLoaders.put(plugin, classLoader);
        this.loadedLibrary.forEach((library, path) -> {
            try {
                classLoader.addURL(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to add URL to classloader.", e);
            }
        });
    }

    @Override
    public IsolatedClassLoader obtainClassLoaderWith(Collection<Library> libraries) {
        return this.obtainClassLoaderWith(libraries.toArray(new Library[0]));
    }

    @Override
    public IsolatedClassLoader obtainClassLoaderWith(Library ... libraries) {
        HashSet<Library> set = new HashSet<Library>(Arrays.asList(libraries));
        for (Library dependency : libraries) {
            if (this.loadedLibrary.containsKey(dependency)) continue;
            throw new IllegalStateException("Dependency " + dependency + " is not loaded.");
        }
        IsolatedClassLoader classLoader = this.loaders.get(set);
        if (classLoader != null) {
            return classLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Library library : set) {
            Path path = this.loadedLibrary.get(library);
            try {
                urls.add(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to isolate classloader.", e);
            }
        }
        classLoader = new IsolatedClassLoader(urls.toArray(new URL[0]));
        this.loaders.put(set, classLoader);
        return classLoader;
    }

    @Override
    public void loadLibrary(Library library, boolean addToUCP, Relocation ... relocations) {
        Path path;
        if (this.loadedLibrary.containsKey(library)) {
            return;
        }
        try {
            path = this.remapLibrary(this.downloadLibrary(library), library, relocations);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load library " + library + ".", e);
        }
        this.loadedLibrary.put(library, path);
        if (addToUCP) {
            this.platform.getClassloader().addPath(path);
            for (URLClassLoaderAccess classLoader : this.pluginClassLoaders.values()) {
                classLoader.addPath(path);
            }
        }
    }

    protected Path downloadLibrary(Library library) throws IOException {
        Path path = this.directory.resolve(library.getFileName() + ".jar");
        if (Files.exists(path, new LinkOption[0]) && this.isChecksumValid(path, library.getChecksum())) {
            return path;
        }
        HttpURLConnection connection = (HttpURLConnection)library.getUrl(library.getRepository()).openConnection();
        connection.setDoInput(true);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0");
        connection.setRequestMethod("GET");
        try (InputStream is = connection.getInputStream();){
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        }
        return this.downloadLibrary(library);
    }

    protected boolean isChecksumValid(Path path, byte[] checksum) {
        if (checksum == null) {
            return true;
        }
        byte[] raw = Files.readAllBytes(path);
        byte[] bytes = this.messageDigest.digest(raw);
        return Arrays.equals(bytes, checksum);
    }

    protected Path remapLibrary(Path rawPath, Library library, Relocation ... relocations) {
        Path relocatedPath = this.directory.resolve(library.getFileName() + "-relocated.jar");
        if (Files.exists(relocatedPath, new LinkOption[0])) {
            return relocatedPath;
        }
        if (relocations.length == 0) {
            return rawPath;
        }
        try {
            this.relocationHandler.remap(rawPath, relocatedPath, Arrays.asList(relocations));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to relocate library " + library.getFileName() + ".", e);
        }
        return relocatedPath;
    }
}

