/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.library.relocate;

import info.cho.passwords.fairy.library.Library;
import info.cho.passwords.fairy.library.LibraryHandler;
import info.cho.passwords.fairy.library.classloader.IsolatedClassLoader;
import info.cho.passwords.fairy.library.relocate.Relocation;
import info.cho.passwords.fairy.library.relocate.RelocationHandler;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelocationHandlerImpl
implements RelocationHandler {
    public static final List<Library> DEPENDENCIES = Arrays.asList(Library.builder().groupId("org.ow2.asm").artifactId("asm").version("9.7").build(), Library.builder().groupId("org.ow2.asm").artifactId("asm-commons").version("9.7").build(), Library.builder().groupId("me.lucko").artifactId("jar-relocator").version("1.7").build());
    private static final String JAR_RELOCATOR_CLASS = "me.lucko.jarrelocator.JarRelocator";
    private static final String JAR_RELOCATOR_RUN_METHOD = "run";
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;

    public RelocationHandlerImpl(LibraryHandler libraryHandler) {
        try {
            for (Library library : DEPENDENCIES) {
                libraryHandler.loadLibrary(library, false, new Relocation[0]);
            }
            IsolatedClassLoader classLoader = libraryHandler.obtainClassLoaderWith(DEPENDENCIES);
            Class<?> jarRelocatorClass = classLoader.loadClass(JAR_RELOCATOR_CLASS);
            this.jarRelocatorConstructor = jarRelocatorClass.getDeclaredConstructor(File.class, File.class, Map.class);
            this.jarRelocatorConstructor.setAccessible(true);
            this.jarRelocatorRunMethod = jarRelocatorClass.getDeclaredMethod(JAR_RELOCATOR_RUN_METHOD, new Class[0]);
            this.jarRelocatorRunMethod.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load relocation handler.", e);
        }
    }

    @Override
    public void remap(Path input, Path output, List<Relocation> relocations) throws Exception {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Relocation relocation : relocations) {
            mappings.put(relocation.getPattern(), relocation.getRelocatedPattern());
        }
        Object relocator = this.jarRelocatorConstructor.newInstance(input.toFile(), output.toFile(), mappings);
        this.jarRelocatorRunMethod.invoke(relocator, new Object[0]);
    }
}

