/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.factory.spigot;

import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.PacketEventsAPI;
import info.cho.passwords.fairy.libs.packetevents.bstats.Metrics;
import info.cho.passwords.fairy.libs.packetevents.bukkit.InternalBukkitListener;
import info.cho.passwords.fairy.libs.packetevents.injector.ChannelInjector;
import info.cho.passwords.fairy.libs.packetevents.injector.SpigotChannelInjector;
import info.cho.passwords.fairy.libs.packetevents.injector.connection.ServerConnectionInitializer;
import info.cho.passwords.fairy.libs.packetevents.manager.InternalBukkitPacketListener;
import info.cho.passwords.fairy.libs.packetevents.manager.player.PlayerManager;
import info.cho.passwords.fairy.libs.packetevents.manager.player.PlayerManagerImpl;
import info.cho.passwords.fairy.libs.packetevents.manager.protocol.ProtocolManager;
import info.cho.passwords.fairy.libs.packetevents.manager.protocol.ProtocolManagerImpl;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerManager;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerManagerImpl;
import info.cho.passwords.fairy.libs.packetevents.netty.NettyManager;
import info.cho.passwords.fairy.libs.packetevents.netty.NettyManagerImpl;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.User;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.states.WrappedBlockState;
import info.cho.passwords.fairy.libs.packetevents.settings.PacketEventsSettings;
import info.cho.passwords.fairy.libs.packetevents.util.BukkitLogManager;
import info.cho.passwords.fairy.libs.packetevents.util.LogManager;
import info.cho.passwords.fairy.libs.packetevents.util.SpigotReflectionUtil;
import info.cho.passwords.fairy.libs.packetevents.util.folia.FoliaScheduler;
import info.cho.passwords.fairy.libs.packetevents.util.protocolsupport.ProtocolSupportUtil;
import info.cho.passwords.fairy.libs.packetevents.util.viaversion.CustomPipelineUtil;
import info.cho.passwords.fairy.libs.packetevents.util.viaversion.ViaVersionUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotPacketEventsBuilder {
    private static PacketEventsAPI<Plugin> API_INSTANCE;

    public static void clearBuildCache() {
        API_INSTANCE = null;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin, PacketEventsSettings settings) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> buildNoCache(Plugin plugin) {
        return SpigotPacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<Plugin> buildNoCache(final Plugin plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<Plugin>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManager playerManager;
            private final NettyManager nettyManager;
            private final SpigotChannelInjector injector;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean lateBind;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerImpl();
                this.serverManager = new ServerManagerImpl();
                this.playerManager = new PlayerManagerImpl();
                this.nettyManager = new NettyManagerImpl();
                this.injector = new SpigotChannelInjector();
                this.logManager = new BukkitLogManager();
                this.lateBind = false;
                this.terminated = false;
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    String id = plugin.getName().toLowerCase();
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    try {
                        SpigotReflectionUtil.init();
                        CustomPipelineUtil.init();
                        WrappedBlockState.ensureLoad();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(ex);
                    }
                    if (!PacketType.isPrepared()) {
                        PacketType.prepare();
                    }
                    boolean bl = this.lateBind = !this.injector.isServerBound();
                    if (!this.lateBind) {
                        this.injector.inject();
                    }
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalBukkitPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized) {
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    Metrics metrics = new Metrics((JavaPlugin)plugin, 11327);
                    metrics.addCustomChart(new Metrics.SimplePie("packetevents_version", () -> this.getVersion().toStringWithoutSnapshot()));
                    Bukkit.getPluginManager().registerEvents((Listener)new InternalBukkitListener(plugin), plugin);
                    if (this.lateBind) {
                        Runnable lateBindTask = () -> {
                            if (this.injector.isServerBound()) {
                                this.injector.inject();
                            }
                        };
                        FoliaScheduler.runTaskOnInit(plugin, lateBindTask);
                    }
                    if (!"true".equalsIgnoreCase(System.getenv("PE_IGNORE_INCOMPATIBILITY"))) {
                        this.checkCompatibility();
                    }
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
                        SpigotChannelInjector injector = (SpigotChannelInjector)PacketEvents.getAPI().getInjector();
                        injector.updatePlayer(user, player);
                    }
                    this.initialized = true;
                }
            }

            private void checkCompatibility() {
                int majorVersion;
                Plugin protocolLibPlugin;
                ViaVersionUtil.checkIfViaIsPresent();
                ProtocolSupportUtil.checkIfProtocolSupportIsPresent();
                Plugin viaPlugin = Bukkit.getPluginManager().getPlugin("ViaVersion");
                if (viaPlugin != null) {
                    String[] ver = viaPlugin.getDescription().getVersion().split("\\.", 3);
                    int major = Integer.parseInt(ver[0]);
                    int minor = Integer.parseInt(ver[1]);
                    if (major < 4 || major == 4 && minor < 5) {
                        PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ViaVersion older than 4.5.0, please update your ViaVersion!");
                        Plugin ourPlugin = this.getPlugin();
                        Bukkit.getPluginManager().disablePlugin(ourPlugin);
                        throw new IllegalStateException("ViaVersion incompatibility! Update to v4.5.0 or newer!");
                    }
                }
                if ((protocolLibPlugin = Bukkit.getPluginManager().getPlugin("ProtocolLib")) != null && (majorVersion = Integer.parseInt(protocolLibPlugin.getDescription().getVersion().split("\\.", 2)[0])) < 5) {
                    PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ProtocolLib version older than v5.0.0. This is no longer works, please update to their dev builds. https://ci.dmulloy2.net/job/ProtocolLib/lastBuild/");
                    Plugin ourPlugin = this.getPlugin();
                    Bukkit.getPluginManager().disablePlugin(ourPlugin);
                    throw new IllegalStateException("ProtocolLib incompatibility! Update to v5.0.0 or newer!");
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    for (User user : ProtocolManager.USERS.values()) {
                        ServerConnectionInitializer.destroyHandlers(user.getChannel());
                    }
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }
        };
    }
}

