/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.injector.handlers;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.PacketEvents;
import info.cho.passwords.fairy.libs.packetevents.exception.PacketProcessException;
import info.cho.passwords.fairy.libs.packetevents.injector.connection.ServerConnectionInitializer;
import info.cho.passwords.fairy.libs.packetevents.injector.handlers.PacketEventsEncoder;
import info.cho.passwords.fairy.libs.packetevents.netty.buffer.ByteBufHelper;
import info.cho.passwords.fairy.libs.packetevents.protocol.ConnectionState;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.User;
import info.cho.passwords.fairy.libs.packetevents.util.ExceptionUtil;
import info.cho.passwords.fairy.libs.packetevents.util.PacketEventsImplHelper;
import info.cho.passwords.fairy.libs.packetevents.util.SpigotReflectionUtil;
import info.cho.passwords.fairy.libs.packetevents.util.folia.FoliaScheduler;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerDisconnect;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public Player player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        Object buffer = PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player, input, true);
        out.add(ByteBufHelper.retain(buffer));
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        boolean didWeCauseThis = ExceptionUtil.isException(cause, PacketProcessException.class);
        if (didWeCauseThis && (this.user == null || this.user.getDecoderState() != ConnectionState.HANDSHAKING)) {
            if (!SpigotReflectionUtil.isMinecraftServerInstanceDebugging()) {
                if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                    cause.printStackTrace();
                } else {
                    PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
                }
            }
            if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
                try {
                    if (this.user != null) {
                        this.user.sendPacket(new WrapperPlayServerDisconnect(Component.text("Invalid packet")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ctx.channel().close();
                if (this.player != null) {
                    FoliaScheduler.getEntityScheduler().runDelayed((Entity)this.player, (Plugin)PacketEvents.getAPI().getPlugin(), o -> this.player.kickPlayer("Invalid packet"), null, 1L);
                }
                if (this.user != null) {
                    PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to invalid packet!");
                }
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (PacketEventsEncoder.COMPRESSION_ENABLED_EVENT == null || event != PacketEventsEncoder.COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, event);
            return;
        }
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

