/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.attribute;

import info.cho.passwords.fairy.libs.packetevents.protocol.attribute.Attribute;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.MappingHelper;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilder;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class Attributes {
    private static final Map<String, Attribute> ATTRIBUTE_MAP = new HashMap<String, Attribute>();
    private static final Map<Byte, Map<Integer, Attribute>> ATTRIBUTE_ID_MAP = new HashMap<Byte, Map<Integer, Attribute>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("attribute/attribute_mappings");
    public static final Attribute GENERIC_ARMOR = Attributes.define("generic.armor");
    public static final Attribute GENERIC_ARMOR_TOUGHNESS = Attributes.define("generic.armor_toughness");
    public static final Attribute GENERIC_ATTACK_DAMAGE = Attributes.define("generic.attack_damage");
    public static final Attribute GENERIC_ATTACK_KNOCKBACK = Attributes.define("generic.attack_knockback");
    public static final Attribute GENERIC_ATTACK_SPEED = Attributes.define("generic.attack_speed");
    public static final Attribute GENERIC_FLYING_SPEED = Attributes.define("generic.flying_speed");
    public static final Attribute GENERIC_FOLLOW_RANGE = Attributes.define("generic.follow_range");
    @ApiStatus.Obsolete
    public static final Attribute HORSE_JUMP_STRENGTH = Attributes.define("horse.jump_strength");
    public static final Attribute GENERIC_KNOCKBACK_RESISTANCE = Attributes.define("generic.knockback_resistance");
    public static final Attribute GENERIC_LUCK = Attributes.define("generic.luck");
    public static final Attribute GENERIC_MAX_HEALTH = Attributes.define("generic.max_health");
    public static final Attribute GENERIC_MOVEMENT_SPEED = Attributes.define("generic.movement_speed");
    public static final Attribute ZOMBIE_SPAWN_REINFORCEMENTS = Attributes.define("zombie.spawn_reinforcements");
    public static final Attribute GENERIC_MAX_ABSORPTION = Attributes.define("generic.max_absorption");
    public static final Attribute PLAYER_BLOCK_BREAK_SPEED = Attributes.define("player.block_break_speed");
    public static final Attribute PLAYER_BLOCK_INTERACTION_RANGE = Attributes.define("player.block_interaction_range");
    public static final Attribute PLAYER_ENTITY_INTERACTION_RANGE = Attributes.define("player.entity_interaction_range");
    public static final Attribute GENERIC_FALL_DAMAGE_MULTIPLIER = Attributes.define("generic.fall_damage_multiplier");
    public static final Attribute GENERIC_GRAVITY = Attributes.define("generic.gravity");
    public static final Attribute GENERIC_JUMP_STRENGTH = Attributes.define("generic.jump_strength");
    public static final Attribute GENERIC_SAFE_FALL_DISTANCE = Attributes.define("generic.safe_fall_distance");
    public static final Attribute GENERIC_SCALE = Attributes.define("generic.scale");
    public static final Attribute GENERIC_STEP_HEIGHT = Attributes.define("generic.step_height");
    public static final Attribute GENERIC_BURNING_TIME = Attributes.define("generic.burning_time");
    public static final Attribute GENERIC_EXPLOSION_KNOCKBACK_RESISTANCE = Attributes.define("generic.explosion_knockback_resistance");
    public static final Attribute PLAYER_MINING_EFFICIENCY = Attributes.define("player.mining_efficiency");
    public static final Attribute GENERIC_MOVEMENT_EFFICIENCY = Attributes.define("generic.movement_efficiency");
    public static final Attribute GENERIC_OXYGEN_BONUS = Attributes.define("generic.oxygen_bonus");
    public static final Attribute PLAYER_SNEAKING_SPEED = Attributes.define("player.sneaking_speed");
    public static final Attribute PLAYER_SUBMERGED_MINING_SPEED = Attributes.define("player.submerged_mining_speed");
    public static final Attribute PLAYER_SWEEPING_DAMAGE_RATIO = Attributes.define("player.sweeping_damage_ratio");
    public static final Attribute GENERIC_WATER_MOVEMENT_EFFICIENCY = Attributes.define("generic.water_movement_efficiency");

    public static Attribute define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        Attribute attribute = new Attribute(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof Attribute) {
                    return this.getName().equals(((Attribute)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, ATTRIBUTE_MAP, ATTRIBUTE_ID_MAP, attribute);
        return attribute;
    }

    public static Attribute getByName(String name) {
        return ATTRIBUTE_MAP.get(name);
    }

    public static Attribute getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, Attribute> idMap = ATTRIBUTE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

