/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.component.builtin.item;

import info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.type.EnchantmentType;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ItemEnchantments
implements Iterable<Map.Entry<EnchantmentType, Integer>> {
    public static final ItemEnchantments EMPTY = new ItemEnchantments(Collections.emptyMap(), true){

        @Override
        public void setShowInTooltip(boolean showInTooltip) {
            throw new UnsupportedOperationException();
        }
    };
    private Map<EnchantmentType, Integer> enchantments;
    private boolean showInTooltip;

    public ItemEnchantments(Map<EnchantmentType, Integer> enchantments, boolean showInTooltip) {
        this.enchantments = Collections.unmodifiableMap(enchantments);
        this.showInTooltip = showInTooltip;
    }

    public static ItemEnchantments read(PacketWrapper<?> wrapper) {
        Map<EnchantmentType, Integer> enchantments = wrapper.readMap(ew -> wrapper.readMappedEntity(EnchantmentTypes.getRegistry()), PacketWrapper::readVarInt);
        boolean showInTooltip = wrapper.readBoolean();
        return new ItemEnchantments(enchantments, showInTooltip);
    }

    public static void write(PacketWrapper<?> wrapper, ItemEnchantments enchantments) {
        ClientVersion version = wrapper.getServerVersion().toClientVersion();
        wrapper.writeMap(enchantments.getEnchantments(), (ew, enchantment) -> ew.writeVarInt(enchantment.getId(version)), PacketWrapper::writeVarInt);
        wrapper.writeBoolean(enchantments.isShowInTooltip());
    }

    public int getEnchantmentLevel(EnchantmentType enchantment) {
        return this.enchantments.getOrDefault(enchantment, 0);
    }

    public void setEnchantmentLevel(EnchantmentType enchantment, int level) {
        if (level == 0) {
            this.enchantments.remove(enchantment);
        } else {
            this.enchantments.put(enchantment, level);
        }
    }

    public boolean isEmpty() {
        return this.getEnchantmentCount() < 1;
    }

    public int getEnchantmentCount() {
        return this.enchantments.size();
    }

    public Map<EnchantmentType, Integer> getEnchantments() {
        return this.enchantments;
    }

    public void setEnchantments(Map<EnchantmentType, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public boolean isShowInTooltip() {
        return this.showInTooltip;
    }

    public void setShowInTooltip(boolean showInTooltip) {
        this.showInTooltip = showInTooltip;
    }

    @Override
    public Iterator<Map.Entry<EnchantmentType, Integer>> iterator() {
        return this.enchantments.entrySet().iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemEnchantments)) {
            return false;
        }
        ItemEnchantments that = (ItemEnchantments)obj;
        if (this.showInTooltip != that.showInTooltip) {
            return false;
        }
        return this.enchantments.equals(that.enchantments);
    }

    public int hashCode() {
        return Objects.hash(this.enchantments, this.showInTooltip);
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + this.enchantments + ", showInTooltip=" + this.showInTooltip + '}';
    }
}

