/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.item.trimmaterial;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.armormaterial.ArmorMaterial;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.armormaterial.ArmorMaterials;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.trimmaterial.StaticTrimMaterial;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.trimmaterial.TrimMaterials;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.type.ItemType;
import info.cho.passwords.fairy.libs.packetevents.protocol.item.type.ItemTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.CopyableEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTFloat;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTString;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.util.adventure.AdventureSerializer;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface TrimMaterial
extends MappedEntity,
CopyableEntity<TrimMaterial> {
    public String getAssetName();

    public ItemType getIngredient();

    public float getItemModelIndex();

    @Nullable
    default public String getArmorMaterialOverride(ArmorMaterial armorMaterial) {
        return this.getOverrideArmorMaterials().get(armorMaterial);
    }

    public Map<ArmorMaterial, String> getOverrideArmorMaterials();

    public Component getDescription();

    public static TrimMaterial read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(TrimMaterials.getRegistry(), TrimMaterial::readDirect);
    }

    public static TrimMaterial readDirect(PacketWrapper<?> wrapper) {
        String assetName = wrapper.readString();
        ItemType ingredient = wrapper.readMappedEntity(ItemTypes::getById);
        float itemModelIndex = wrapper.readFloat();
        Map<ArmorMaterial, String> overrideArmorMaterials = wrapper.readMap(ew -> ew.readMappedEntity(ArmorMaterials::getById), PacketWrapper::readString);
        Component description = wrapper.readComponent();
        return new StaticTrimMaterial(assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static void write(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeMappedEntityOrDirect(material, TrimMaterial::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, TrimMaterial material) {
        wrapper.writeString(material.getAssetName());
        wrapper.writeMappedEntity(material.getIngredient());
        wrapper.writeFloat(material.getItemModelIndex());
        wrapper.writeMap(material.getOverrideArmorMaterials(), PacketWrapper::writeMappedEntity, PacketWrapper::writeString);
        wrapper.writeComponent(material.getDescription());
    }

    public static TrimMaterial decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        Map<ArmorMaterial, String> overrideArmorMaterials;
        NBTCompound compound = (NBTCompound)nbt;
        String assetName = compound.getStringTagValueOrThrow("asset_name");
        ItemType ingredient = ItemTypes.getByName(compound.getStringTagValueOrThrow("ingredient"));
        float itemModelIndex = compound.getNumberTagOrThrow("item_model_index").getAsFloat();
        NBTCompound overrideArmorMaterialsTag = compound.getCompoundTagOrNull("override_armor_materials");
        if (overrideArmorMaterialsTag != null) {
            overrideArmorMaterials = new HashMap();
            for (Map.Entry<String, NBT> entry : overrideArmorMaterialsTag.getTags().entrySet()) {
                ArmorMaterial material = ArmorMaterials.getByName(entry.getKey());
                String override = ((NBTString)entry.getValue()).getValue();
                overrideArmorMaterials.put(material, override);
            }
        } else {
            overrideArmorMaterials = Collections.emptyMap();
        }
        Component description = AdventureSerializer.fromNbt(((NBTCompound)nbt).getTagOrThrow("description"));
        return new StaticTrimMaterial(data, assetName, ingredient, itemModelIndex, overrideArmorMaterials, description);
    }

    public static NBT encode(TrimMaterial material, ClientVersion version) {
        NBTCompound overrideArmorMaterialsTag;
        if (!material.getOverrideArmorMaterials().isEmpty()) {
            overrideArmorMaterialsTag = new NBTCompound();
            for (Map.Entry<ArmorMaterial, String> entry : material.getOverrideArmorMaterials().entrySet()) {
                String materialName = entry.getKey().getName().toString();
                NBTString overrideTag = new NBTString(entry.getValue());
                overrideArmorMaterialsTag.setTag(materialName, overrideTag);
            }
        } else {
            overrideArmorMaterialsTag = null;
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_name", new NBTString(material.getAssetName()));
        compound.setTag("ingredient", new NBTString(material.getIngredient().getName().toString()));
        compound.setTag("item_model_index", new NBTFloat(material.getItemModelIndex()));
        if (overrideArmorMaterialsTag != null) {
            compound.setTag("override_armor_materials", overrideArmorMaterialsTag);
        }
        compound.setTag("description", AdventureSerializer.toNbt(material.getDescription()));
        return compound;
    }
}

