/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.particle.data;

import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTInt;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTNumber;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.data.ParticleData;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.data.ParticleDustData;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.util.MathUtil;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;

public class ParticleColorData
extends ParticleData {
    private int color;

    public ParticleColorData(int color) {
        this.color = color;
    }

    public static ParticleColorData read(PacketWrapper<?> wrapper) {
        int color = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5) ? wrapper.readInt() : 0;
        return new ParticleColorData(color);
    }

    public static void write(PacketWrapper<?> wrapper, ParticleColorData data) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            wrapper.writeInt(data.color);
        }
    }

    public static ParticleColorData decode(NBTCompound compound, ClientVersion version) {
        int argb;
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            NBT colorTag = compound.getTagOrThrow("color");
            if (colorTag instanceof NBTNumber) {
                argb = ((NBTNumber)colorTag).getAsInt();
            } else {
                float[] color = ParticleDustData.decodeColor(colorTag);
                assert (color.length == 4);
                argb = MathUtil.floor(color[0] * 255.0f) << 24 | MathUtil.floor(color[1] * 255.0f) << 16 | MathUtil.floor(color[2] * 255.0f) << 8 | MathUtil.floor(color[3] * 255.0f);
            }
        } else {
            argb = -1;
        }
        return new ParticleColorData(argb);
    }

    public static void encode(ParticleColorData data, ClientVersion version, NBTCompound compound) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
            compound.setTag("color", new NBTInt(data.color));
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

