/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.potion;

import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.potion.Potion;
import info.cho.passwords.fairy.libs.packetevents.protocol.potion.PotionType;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.MappingHelper;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilder;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Potions {
    private static final Map<String, Potion> POTION_MAP = new HashMap<String, Potion>();
    private static final Map<Byte, Map<Integer, Potion>> POTION_ID_MAP = new HashMap<Byte, Map<Integer, Potion>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("item/item_potion_mappings");
    public static final Potion WATER = Potions.define("water");
    public static final Potion MUNDANE = Potions.define("mundane");
    public static final Potion THICK = Potions.define("thick");
    public static final Potion AWKWARD = Potions.define("awkward");
    public static final Potion NIGHT_VISION = Potions.define("night_vision");
    public static final Potion LONG_NIGHT_VISION = Potions.define("long_night_vision");
    public static final Potion INVISIBILITY = Potions.define("invisibility");
    public static final Potion LONG_INVISIBILITY = Potions.define("long_invisibility");
    public static final Potion LEAPING = Potions.define("leaping");
    public static final Potion LONG_LEAPING = Potions.define("long_leaping");
    public static final Potion STRONG_LEAPING = Potions.define("strong_leaping");
    public static final Potion FIRE_RESISTANCE = Potions.define("fire_resistance");
    public static final Potion LONG_FIRE_RESISTANCE = Potions.define("long_fire_resistance");
    public static final Potion SWIFTNESS = Potions.define("swiftness");
    public static final Potion LONG_SWIFTNESS = Potions.define("long_swiftness");
    public static final Potion STRONG_SWIFTNESS = Potions.define("strong_swiftness");
    public static final Potion SLOWNESS = Potions.define("slowness");
    public static final Potion LONG_SLOWNESS = Potions.define("long_slowness");
    public static final Potion STRONG_SLOWNESS = Potions.define("strong_slowness");
    public static final Potion TURTLE_MASTER = Potions.define("turtle_master");
    public static final Potion LONG_TURTLE_MASTER = Potions.define("long_turtle_master");
    public static final Potion STRONG_TURTLE_MASTER = Potions.define("strong_turtle_master");
    public static final Potion WATER_BREATHING = Potions.define("water_breathing");
    public static final Potion LONG_WATER_BREATHING = Potions.define("long_water_breathing");
    public static final Potion HEALING = Potions.define("healing");
    public static final Potion STRONG_HEALING = Potions.define("strong_healing");
    public static final Potion HARMING = Potions.define("harming");
    public static final Potion STRONG_HARMING = Potions.define("strong_harming");
    public static final Potion POISON = Potions.define("poison");
    public static final Potion LONG_POISON = Potions.define("long_poison");
    public static final Potion STRONG_POISON = Potions.define("strong_poison");
    public static final Potion REGENERATION = Potions.define("regeneration");
    public static final Potion LONG_REGENERATION = Potions.define("long_regeneration");
    public static final Potion STRONG_REGENERATION = Potions.define("strong_regeneration");
    public static final Potion STRENGTH = Potions.define("strength");
    public static final Potion LONG_STRENGTH = Potions.define("long_strength");
    public static final Potion STRONG_STRENGTH = Potions.define("strong_strength");
    public static final Potion WEAKNESS = Potions.define("weakness");
    public static final Potion LONG_WEAKNESS = Potions.define("long_weakness");
    public static final Potion LUCK = Potions.define("luck");
    public static final Potion SLOW_FALLING = Potions.define("slow_falling");
    public static final Potion LONG_SLOW_FALLING = Potions.define("long_slow_falling");
    public static final Potion WIND_CHARGED = Potions.define("wind_charged");
    public static final Potion WEAVING = Potions.define("weaving");
    public static final Potion OOZING = Potions.define("oozing");
    public static final Potion INFESTED = Potions.define("infested");

    public static Potion define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        Potion potion = new Potion(){

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                return MappingHelper.getId(version, TYPES_BUILDER, data);
            }

            public boolean equals(Object obj) {
                if (obj instanceof PotionType) {
                    return this.getName().equals(((PotionType)obj).getName());
                }
                return false;
            }
        };
        MappingHelper.registerMapping(TYPES_BUILDER, POTION_MAP, POTION_ID_MAP, potion);
        return potion;
    }

    @Nullable
    public static Potion getByName(String name) {
        return POTION_MAP.get(name);
    }

    @Nullable
    public static Potion getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, Potion> idMap = POTION_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

