/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.world.biome;

import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.biome.Biome;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.MappingHelper;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.VersionedRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public final class Biomes {
    private static final VersionedRegistry<Biome> REGISTRY = new VersionedRegistry("worldgen/biome", "world/biome_mappings");
    private static final Map<ResourceLocation, NBTCompound> BIOME_DATA = new HashMap<ResourceLocation, NBTCompound>();
    public static final Biome BADLANDS;
    public static final Biome BAMBOO_JUNGLE;
    public static final Biome BASALT_DELTAS;
    public static final Biome BEACH;
    public static final Biome BIRCH_FOREST;
    public static final Biome CHERRY_GROVE;
    public static final Biome COLD_OCEAN;
    public static final Biome CRIMSON_FOREST;
    public static final Biome DARK_FOREST;
    public static final Biome DEEP_COLD_OCEAN;
    public static final Biome DEEP_DARK;
    public static final Biome DEEP_FROZEN_OCEAN;
    public static final Biome DEEP_LUKEWARM_OCEAN;
    public static final Biome DEEP_OCEAN;
    public static final Biome DESERT;
    public static final Biome DRIPSTONE_CAVES;
    public static final Biome END_BARRENS;
    public static final Biome END_HIGHLANDS;
    public static final Biome END_MIDLANDS;
    public static final Biome ERODED_BADLANDS;
    public static final Biome FLOWER_FOREST;
    public static final Biome FOREST;
    public static final Biome FROZEN_OCEAN;
    public static final Biome FROZEN_PEAKS;
    public static final Biome FROZEN_RIVER;
    public static final Biome GROVE;
    public static final Biome ICE_SPIKES;
    public static final Biome JAGGED_PEAKS;
    public static final Biome JUNGLE;
    public static final Biome LUKEWARM_OCEAN;
    public static final Biome LUSH_CAVES;
    public static final Biome MANGROVE_SWAMP;
    public static final Biome MEADOW;
    public static final Biome MUSHROOM_FIELDS;
    public static final Biome NETHER_WASTES;
    public static final Biome OCEAN;
    public static final Biome OLD_GROWTH_BIRCH_FOREST;
    public static final Biome OLD_GROWTH_PINE_TAIGA;
    public static final Biome OLD_GROWTH_SPRUCE_TAIGA;
    public static final Biome PLAINS;
    public static final Biome RIVER;
    public static final Biome SAVANNA;
    public static final Biome SAVANNA_PLATEAU;
    public static final Biome SMALL_END_ISLANDS;
    public static final Biome SNOWY_BEACH;
    public static final Biome SNOWY_PLAINS;
    public static final Biome SNOWY_SLOPES;
    public static final Biome SNOWY_TAIGA;
    public static final Biome SOUL_SAND_VALLEY;
    public static final Biome SPARSE_JUNGLE;
    public static final Biome STONY_PEAKS;
    public static final Biome STONY_SHORE;
    public static final Biome SUNFLOWER_PLAINS;
    public static final Biome SWAMP;
    public static final Biome TAIGA;
    public static final Biome THE_END;
    public static final Biome THE_VOID;
    public static final Biome WARM_OCEAN;
    public static final Biome WARPED_FOREST;
    public static final Biome WINDSWEPT_FOREST;
    public static final Biome WINDSWEPT_GRAVELLY_HILLS;
    public static final Biome WINDSWEPT_HILLS;
    public static final Biome WINDSWEPT_SAVANNA;
    public static final Biome WOODED_BADLANDS;

    private Biomes() {
    }

    @ApiStatus.Internal
    public static Biome define(String key) {
        return REGISTRY.define(key, data -> {
            NBTCompound dataTag = BIOME_DATA.get(data.getName());
            if (dataTag == null) {
                throw new IllegalArgumentException("Can't define biome " + data.getName() + ", no data found");
            }
            return Biome.decode(dataTag, ClientVersion.getLatest(), data);
        });
    }

    public static VersionedRegistry<Biome> getRegistry() {
        return REGISTRY;
    }

    static {
        try (SequentialNBTReader.Compound dataTag = MappingHelper.decompress("mappings/world/biome_data");){
            while (dataTag.hasNext()) {
                Object entry = dataTag.next();
                if (((String)entry.getKey()).equals("version")) continue;
                ResourceLocation biomeKey = new ResourceLocation((String)entry.getKey());
                BIOME_DATA.put(biomeKey, ((SequentialNBTReader.Compound)entry.getValue()).readFully());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while reading biome data", exception);
        }
        BADLANDS = Biomes.define("badlands");
        BAMBOO_JUNGLE = Biomes.define("bamboo_jungle");
        BASALT_DELTAS = Biomes.define("basalt_deltas");
        BEACH = Biomes.define("beach");
        BIRCH_FOREST = Biomes.define("birch_forest");
        CHERRY_GROVE = Biomes.define("cherry_grove");
        COLD_OCEAN = Biomes.define("cold_ocean");
        CRIMSON_FOREST = Biomes.define("crimson_forest");
        DARK_FOREST = Biomes.define("dark_forest");
        DEEP_COLD_OCEAN = Biomes.define("deep_cold_ocean");
        DEEP_DARK = Biomes.define("deep_dark");
        DEEP_FROZEN_OCEAN = Biomes.define("deep_frozen_ocean");
        DEEP_LUKEWARM_OCEAN = Biomes.define("deep_lukewarm_ocean");
        DEEP_OCEAN = Biomes.define("deep_ocean");
        DESERT = Biomes.define("desert");
        DRIPSTONE_CAVES = Biomes.define("dripstone_caves");
        END_BARRENS = Biomes.define("end_barrens");
        END_HIGHLANDS = Biomes.define("end_highlands");
        END_MIDLANDS = Biomes.define("end_midlands");
        ERODED_BADLANDS = Biomes.define("eroded_badlands");
        FLOWER_FOREST = Biomes.define("flower_forest");
        FOREST = Biomes.define("forest");
        FROZEN_OCEAN = Biomes.define("frozen_ocean");
        FROZEN_PEAKS = Biomes.define("frozen_peaks");
        FROZEN_RIVER = Biomes.define("frozen_river");
        GROVE = Biomes.define("grove");
        ICE_SPIKES = Biomes.define("ice_spikes");
        JAGGED_PEAKS = Biomes.define("jagged_peaks");
        JUNGLE = Biomes.define("jungle");
        LUKEWARM_OCEAN = Biomes.define("lukewarm_ocean");
        LUSH_CAVES = Biomes.define("lush_caves");
        MANGROVE_SWAMP = Biomes.define("mangrove_swamp");
        MEADOW = Biomes.define("meadow");
        MUSHROOM_FIELDS = Biomes.define("mushroom_fields");
        NETHER_WASTES = Biomes.define("nether_wastes");
        OCEAN = Biomes.define("ocean");
        OLD_GROWTH_BIRCH_FOREST = Biomes.define("old_growth_birch_forest");
        OLD_GROWTH_PINE_TAIGA = Biomes.define("old_growth_pine_taiga");
        OLD_GROWTH_SPRUCE_TAIGA = Biomes.define("old_growth_spruce_taiga");
        PLAINS = Biomes.define("plains");
        RIVER = Biomes.define("river");
        SAVANNA = Biomes.define("savanna");
        SAVANNA_PLATEAU = Biomes.define("savanna_plateau");
        SMALL_END_ISLANDS = Biomes.define("small_end_islands");
        SNOWY_BEACH = Biomes.define("snowy_beach");
        SNOWY_PLAINS = Biomes.define("snowy_plains");
        SNOWY_SLOPES = Biomes.define("snowy_slopes");
        SNOWY_TAIGA = Biomes.define("snowy_taiga");
        SOUL_SAND_VALLEY = Biomes.define("soul_sand_valley");
        SPARSE_JUNGLE = Biomes.define("sparse_jungle");
        STONY_PEAKS = Biomes.define("stony_peaks");
        STONY_SHORE = Biomes.define("stony_shore");
        SUNFLOWER_PLAINS = Biomes.define("sunflower_plains");
        SWAMP = Biomes.define("swamp");
        TAIGA = Biomes.define("taiga");
        THE_END = Biomes.define("the_end");
        THE_VOID = Biomes.define("the_void");
        WARM_OCEAN = Biomes.define("warm_ocean");
        WARPED_FOREST = Biomes.define("warped_forest");
        WINDSWEPT_FOREST = Biomes.define("windswept_forest");
        WINDSWEPT_GRAVELLY_HILLS = Biomes.define("windswept_gravelly_hills");
        WINDSWEPT_HILLS = Biomes.define("windswept_hills");
        WINDSWEPT_SAVANNA = Biomes.define("windswept_savanna");
        WOODED_BADLANDS = Biomes.define("wooded_badlands");
        BIOME_DATA.clear();
        REGISTRY.unloadMappings();
    }
}

