/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.world.blockentity;

import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.blockentity.BlockEntityType;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilder;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BlockEntityTypes {
    private static final Map<String, BlockEntityType> BLOCK_ENTITY_TYPE_MAP = new HashMap<String, BlockEntityType>();
    private static final Map<Byte, Map<Integer, BlockEntityType>> BLOCK_ENTITY_TYPE_ID_MAP = new HashMap<Byte, Map<Integer, BlockEntityType>>();
    private static final TypesBuilder TYPES_BUILDER = new TypesBuilder("block/block_entity_type_mappings");
    public static final BlockEntityType FURNACE = BlockEntityTypes.define("furnace");
    public static final BlockEntityType CHEST = BlockEntityTypes.define("chest");
    public static final BlockEntityType TRAPPED_CHEST = BlockEntityTypes.define("trapped_chest");
    public static final BlockEntityType ENDER_CHEST = BlockEntityTypes.define("ender_chest");
    public static final BlockEntityType JUKEBOX = BlockEntityTypes.define("jukebox");
    public static final BlockEntityType DISPENSER = BlockEntityTypes.define("dispenser");
    public static final BlockEntityType DROPPER = BlockEntityTypes.define("dropper");
    public static final BlockEntityType SIGN = BlockEntityTypes.define("sign");
    public static final BlockEntityType HANGING_SIGN = BlockEntityTypes.define("hanging_sign");
    public static final BlockEntityType MOB_SPAWNER = BlockEntityTypes.define("mob_spawner");
    public static final BlockEntityType PISTON = BlockEntityTypes.define("piston");
    public static final BlockEntityType BREWING_STAND = BlockEntityTypes.define("brewing_stand");
    public static final BlockEntityType ENCHANTING_TABLE = BlockEntityTypes.define("enchanting_table");
    public static final BlockEntityType END_PORTAL = BlockEntityTypes.define("end_portal");
    public static final BlockEntityType BEACON = BlockEntityTypes.define("beacon");
    public static final BlockEntityType SKULL = BlockEntityTypes.define("skull");
    public static final BlockEntityType DAYLIGHT_DETECTOR = BlockEntityTypes.define("daylight_detector");
    public static final BlockEntityType HOPPER = BlockEntityTypes.define("hopper");
    public static final BlockEntityType COMPARATOR = BlockEntityTypes.define("comparator");
    public static final BlockEntityType BANNER = BlockEntityTypes.define("banner");
    public static final BlockEntityType STRUCTURE_BLOCK = BlockEntityTypes.define("structure_block");
    public static final BlockEntityType END_GATEWAY = BlockEntityTypes.define("end_gateway");
    public static final BlockEntityType COMMAND_BLOCK = BlockEntityTypes.define("command_block");
    public static final BlockEntityType SHULKER_BOX = BlockEntityTypes.define("shulker_box");
    public static final BlockEntityType BED = BlockEntityTypes.define("bed");
    public static final BlockEntityType CONDUIT = BlockEntityTypes.define("conduit");
    public static final BlockEntityType BARREL = BlockEntityTypes.define("barrel");
    public static final BlockEntityType SMOKER = BlockEntityTypes.define("smoker");
    public static final BlockEntityType BLAST_FURNACE = BlockEntityTypes.define("blast_furnace");
    public static final BlockEntityType LECTERN = BlockEntityTypes.define("lectern");
    public static final BlockEntityType BELL = BlockEntityTypes.define("bell");
    public static final BlockEntityType JIGSAW = BlockEntityTypes.define("jigsaw");
    public static final BlockEntityType CAMPFIRE = BlockEntityTypes.define("campfire");
    public static final BlockEntityType BEEHIVE = BlockEntityTypes.define("beehive");
    public static final BlockEntityType SCULK_SENSOR = BlockEntityTypes.define("sculk_sensor");
    public static final BlockEntityType CALIBRATED_SCULK_SENSOR = BlockEntityTypes.define("calibrated_sculk_sensor");
    public static final BlockEntityType SCULK_CATALYST = BlockEntityTypes.define("sculk_catalyst");
    public static final BlockEntityType SCULK_SHRIEKER = BlockEntityTypes.define("sculk_shrieker");
    public static final BlockEntityType CHISELED_BOOKSHELF = BlockEntityTypes.define("chiseled_bookshelf");
    public static final BlockEntityType BRUSHABLE_BLOCK = BlockEntityTypes.define("brushable_block");
    public static final BlockEntityType DECORATED_POT = BlockEntityTypes.define("decorated_pot");
    public static final BlockEntityType CRAFTER = BlockEntityTypes.define("crafter");
    public static final BlockEntityType TRIAL_SPAWNER = BlockEntityTypes.define("trial_spawner");
    public static final BlockEntityType VAULT = BlockEntityTypes.define("vault");

    public static BlockEntityType define(String key) {
        final TypesBuilderData data = TYPES_BUILDER.define(key);
        BlockEntityType blockEntityType = new BlockEntityType(){
            private final int[] ids;
            {
                this.ids = data.getData();
            }

            @Override
            public ResourceLocation getName() {
                return data.getName();
            }

            @Override
            public int getId(ClientVersion version) {
                int index = TYPES_BUILDER.getDataIndex(version);
                return this.ids[index];
            }

            public boolean equals(Object obj) {
                if (obj instanceof BlockEntityType) {
                    return this.getName().equals(((BlockEntityType)obj).getName());
                }
                return false;
            }
        };
        BLOCK_ENTITY_TYPE_MAP.put(blockEntityType.getName().toString(), blockEntityType);
        for (ClientVersion version : TYPES_BUILDER.getVersions()) {
            int index = TYPES_BUILDER.getDataIndex(version);
            Map idMap = BLOCK_ENTITY_TYPE_ID_MAP.computeIfAbsent((byte)index, k -> new HashMap());
            idMap.put(blockEntityType.getId(version), blockEntityType);
        }
        return blockEntityType;
    }

    public static BlockEntityType getByName(String name) {
        return BLOCK_ENTITY_TYPE_MAP.get(name);
    }

    public static BlockEntityType getById(ClientVersion version, int id) {
        int index = TYPES_BUILDER.getDataIndex(version);
        Map<Integer, BlockEntityType> idMap = BLOCK_ENTITY_TYPE_ID_MAP.get((byte)index);
        return idMap.get(id);
    }

    public static Collection<BlockEntityType> values() {
        return Collections.unmodifiableCollection(BLOCK_ENTITY_TYPE_MAP.values());
    }

    static {
        TYPES_BUILDER.unloadFileMappings();
    }
}

