/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette;

import info.cho.passwords.fairy.libs.packetevents.protocol.stream.NetStreamInput;
import info.cho.passwords.fairy.libs.packetevents.protocol.stream.NetStreamOutput;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.GlobalPalette;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.ListPalette;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.MapPalette;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.Palette;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.PaletteType;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.palette.SingletonPalette;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.storage.BaseStorage;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.storage.BitStorage;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.chunk.storage.LegacyFlexibleStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataPalette {
    public static final int GLOBAL_PALETTE_BITS_PER_ENTRY = 15;
    @NotNull
    public Palette palette;
    public BaseStorage storage;
    public final PaletteType paletteType;

    public static DataPalette createForChunk() {
        return DataPalette.createEmpty(PaletteType.CHUNK);
    }

    public static DataPalette createForBiome() {
        return DataPalette.createEmpty(PaletteType.BIOME);
    }

    public static DataPalette createEmpty(PaletteType paletteType) {
        return new DataPalette(new ListPalette(paletteType.getMinBitsPerEntry()), new BitStorage(paletteType.getMinBitsPerEntry(), paletteType.getStorageSize()), paletteType);
    }

    public DataPalette(@NotNull Palette palette, @Nullable BaseStorage storage, PaletteType paletteType) {
        this.palette = palette;
        this.storage = storage;
        this.paletteType = paletteType;
    }

    public static DataPalette read(NetStreamInput in, PaletteType paletteType) {
        return DataPalette.read(in, paletteType, true);
    }

    public static DataPalette read(NetStreamInput in, PaletteType paletteType, boolean allowSingletonPalette) {
        BitStorage storage;
        byte bitsPerEntry = in.readByte();
        Palette palette = DataPalette.readPalette(paletteType, bitsPerEntry, in, allowSingletonPalette);
        if (!(palette instanceof SingletonPalette)) {
            int length = in.readVarInt();
            storage = new BitStorage(bitsPerEntry, paletteType.getStorageSize(), in.readLongs(length));
        } else {
            in.readVarInt();
            storage = null;
        }
        return new DataPalette(palette, storage, paletteType);
    }

    public static void write(NetStreamOutput out, DataPalette palette) {
        if (palette.palette instanceof SingletonPalette) {
            out.writeByte(0);
            out.writeVarInt(palette.palette.idToState(0));
            out.writeVarInt(0);
            return;
        }
        out.writeByte(palette.storage.getBitsPerEntry());
        if (!(palette.palette instanceof GlobalPalette)) {
            int paletteLength = palette.palette.size();
            out.writeVarInt(paletteLength);
            for (int i = 0; i < paletteLength; ++i) {
                out.writeVarInt(palette.palette.idToState(i));
            }
        }
        long[] data = palette.storage.getData();
        out.writeVarInt(data.length);
        out.writeLongs(data);
    }

    public static DataPalette readLegacy(NetStreamInput in) {
        LegacyFlexibleStorage storage;
        int bitsPerEntry = in.readByte() & 0xFF;
        Palette palette = DataPalette.readPalette(PaletteType.CHUNK, bitsPerEntry, in, false);
        if (!(palette instanceof SingletonPalette)) {
            int length = in.readVarInt();
            storage = new LegacyFlexibleStorage(bitsPerEntry, in.readLongs(length));
        } else {
            in.readVarInt();
            storage = null;
        }
        return new DataPalette(palette, storage, PaletteType.CHUNK);
    }

    public int get(int x, int y, int z) {
        if (this.storage != null) {
            int id = this.storage.get(DataPalette.index(this.paletteType, x, y, z));
            return this.palette.idToState(id);
        }
        return this.palette.idToState(0);
    }

    public int set(int x, int y, int z, int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resize();
            id = this.palette.stateToId(state);
        }
        if (this.storage != null) {
            int index = DataPalette.index(this.paletteType, x, y, z);
            int curr = this.storage.get(index);
            this.storage.set(index, id);
            return curr;
        }
        return state;
    }

    private static Palette readPalette(PaletteType paletteType, int bitsPerEntry, NetStreamInput in, boolean allowSingletonPalette) {
        if (bitsPerEntry > paletteType.getMaxBitsPerEntry()) {
            return new GlobalPalette();
        }
        if (bitsPerEntry == 0 && allowSingletonPalette) {
            return new SingletonPalette(in);
        }
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry, in);
        }
        return new MapPalette(bitsPerEntry, in);
    }

    private int sanitizeBitsPerEntry(int bitsPerEntry) {
        if (bitsPerEntry <= this.paletteType.getMaxBitsPerEntry()) {
            return Math.max(this.paletteType.getMinBitsPerEntry(), bitsPerEntry);
        }
        return 15;
    }

    private void resize() {
        Palette oldPalette = this.palette;
        BaseStorage oldData = this.storage;
        int bitsPerEntry = this.sanitizeBitsPerEntry(oldPalette instanceof SingletonPalette ? 1 : oldData.getBitsPerEntry() + 1);
        this.palette = DataPalette.createPalette(bitsPerEntry, this.paletteType);
        this.storage = new BitStorage(bitsPerEntry, this.paletteType.getStorageSize());
        if (oldPalette instanceof SingletonPalette) {
            this.palette.stateToId(oldPalette.idToState(0));
        } else {
            for (int i = 0; i < this.paletteType.getStorageSize(); ++i) {
                this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
            }
        }
    }

    private static Palette createPalette(int bitsPerEntry, PaletteType paletteType) {
        if (bitsPerEntry <= paletteType.getMinBitsPerEntry()) {
            return new ListPalette(bitsPerEntry);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntry()) {
            return new MapPalette(bitsPerEntry);
        }
        return new GlobalPalette();
    }

    private static int index(PaletteType paletteType, int x, int y, int z) {
        return (y << paletteType.getBitShift() | z) << paletteType.getBitShift() | x;
    }
}

