/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.protocol.world.painting;

import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.CopyableEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.mapper.MappedEntity;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTInt;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTString;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.ClientVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.painting.StaticPaintingVariant;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.TypesBuilderData;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface PaintingVariant
extends MappedEntity,
CopyableEntity<PaintingVariant> {
    public int getWidth();

    public int getHeight();

    public ResourceLocation getAssetId();

    public static PaintingVariant readDirect(PacketWrapper<?> wrapper) {
        int width = wrapper.readVarInt();
        int height = wrapper.readVarInt();
        ResourceLocation assetId = wrapper.readIdentifier();
        return new StaticPaintingVariant(width, height, assetId);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, PaintingVariant variant) {
        wrapper.writeVarInt(variant.getWidth());
        wrapper.writeVarInt(variant.getHeight());
        wrapper.writeIdentifier(variant.getAssetId());
    }

    public static PaintingVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        int width = compound.getNumberTagOrThrow("width").getAsInt();
        int height = compound.getNumberTagOrThrow("height").getAsInt();
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticPaintingVariant(data, width, height, assetId);
    }

    public static NBT encode(PaintingVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("width", new NBTInt(variant.getWidth()));
        compound.setTag("height", new NBTInt(variant.getHeight()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

