/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.util.adventure;

import info.cho.passwords.fairy.libs.kyori.adventure.key.Key;
import info.cho.passwords.fairy.libs.kyori.adventure.key.Keyed;
import info.cho.passwords.fairy.libs.kyori.adventure.nbt.api.BinaryTagHolder;
import info.cho.passwords.fairy.libs.kyori.adventure.text.BlockNBTComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.libs.kyori.adventure.text.EntityNBTComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.KeybindComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.NBTComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.ScoreComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.SelectorComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.StorageNBTComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.TextComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.TranslatableComponent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.TranslationArgument;
import info.cho.passwords.fairy.libs.kyori.adventure.text.event.ClickEvent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.event.DataComponentValue;
import info.cho.passwords.fairy.libs.kyori.adventure.text.event.HoverEvent;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.NamedTextColor;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.Style;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.TextColor;
import info.cho.passwords.fairy.libs.kyori.adventure.text.format.TextDecoration;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.ComponentSerializer;
import info.cho.passwords.fairy.libs.packetevents.adventure.serializer.gson.BackwardCompatUtil;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBT;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTByte;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTByteArray;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTCompound;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTDouble;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTFloat;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTInt;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTIntArray;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTList;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTLong;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTLongArray;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTNumber;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTShort;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTString;
import info.cho.passwords.fairy.libs.packetevents.protocol.nbt.NBTType;
import info.cho.passwords.fairy.libs.packetevents.util.UniqueIdUtil;
import info.cho.passwords.fairy.libs.packetevents.util.adventure.AdventureIndexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdventureNBTSerializer
implements ComponentSerializer<Component, Component, NBT> {
    private final boolean downsampleColor;

    public AdventureNBTSerializer(boolean downsampleColor) {
        this.downsampleColor = downsampleColor;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Component deserialize(@NotNull NBT input) {
        void var20_28;
        NBTType<?> type;
        Function<NBT, String> textFunction;
        if (input.getType() == NBTType.STRING) {
            return Component.text(((NBTString)input).getValue());
        }
        if (input.getType() == NBTType.BYTE && ((NBTByte)input).getAsByte() < 2) {
            return Component.text(((NBTByte)input).getAsByte() == 1);
        }
        if (input instanceof NBTNumber) {
            return Component.text(((NBTNumber)input).getAsInt());
        }
        NBTCompound compound = AdventureNBTSerializer.requireType(input, NBTType.COMPOUND);
        NBTReader reader = new NBTReader(compound);
        String text = reader.read("text", textFunction = nbt -> {
            if (nbt.getType() == NBTType.STRING) {
                return ((NBTString)nbt).getValue();
            }
            if (nbt.getType() == NBTType.BYTE && ((NBTByte)nbt).getAsByte() < 2) {
                return String.valueOf(((NBTByte)nbt).getAsByte() == 1);
            }
            if (nbt instanceof NBTNumber) {
                return String.valueOf(((NBTNumber)nbt).getAsInt());
            }
            throw new IllegalStateException("Don't know how to deserialize " + nbt.getType() + " to text");
        });
        if (text == null) {
            text = reader.read("", textFunction);
        }
        String translate = (String)reader.readUTF("translate", Function.identity());
        String translateFallback = (String)reader.readUTF("fallback", Function.identity());
        List translateWith = BackwardCompatUtil.IS_4_15_0_OR_NEWER ? ((type = reader.type("with")) == NBTType.INT_ARRAY ? reader.readIntArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((int[])params).length);
            for (int param : params) {
                args.add(TranslationArgument.numeric(param));
            }
            return args;
        }) : (type == NBTType.BYTE_ARRAY ? reader.readByteArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((byte[])params).length);
            for (byte param : params) {
                args.add(TranslationArgument.bool(param != 0));
            }
            return args;
        }) : (type == NBTType.LONG_ARRAY ? reader.readLongArray("with", params -> {
            ArrayList<TranslationArgument> args = new ArrayList<TranslationArgument>(((long[])params).length);
            for (long param : params) {
                args.add(TranslationArgument.numeric(param));
            }
            return args;
        }) : reader.readList("with", this::deserializeTranslationArgumentList)))) : reader.readList("with", this::deserializeComponentList);
        NBTReader score = reader.child("score");
        String selector = (String)reader.readUTF("selector", Function.identity());
        String keybind = (String)reader.readUTF("keybind", Function.identity());
        String nbt2 = (String)reader.readUTF("nbt", Function.identity());
        Boolean nbtInterpret = (Boolean)reader.readBoolean("interpret", Function.identity());
        BlockNBTComponent.Pos nbtBlock = reader.readUTF("block", BlockNBTComponent.Pos::fromString);
        String nbtEntity = (String)reader.readUTF("entity", Function.identity());
        Key nbtStorage = reader.readUTF("storage", Key::key);
        List extra = reader.readList("extra", this::deserializeComponentList);
        Component separator = reader.read("separator", this::deserialize);
        Style style = this.deserializeStyle(compound);
        if (text != null) {
            TextComponent.Builder builder = Component.text().content(text);
        } else if (translate != null) {
            TranslatableComponent.Builder i18nBuilder;
            TranslatableComponent.Builder builder = i18nBuilder = Component.translatable().key(translate);
            if (translateWith != null) {
                if (BackwardCompatUtil.IS_4_15_0_OR_NEWER) {
                    i18nBuilder.arguments(translateWith);
                } else {
                    i18nBuilder.args(translateWith);
                }
            }
            if (BackwardCompatUtil.IS_4_13_0_OR_NEWER) {
                i18nBuilder.fallback(translateFallback);
            }
        } else if (score != null) {
            ScoreComponent.Builder builder = Component.score().name((String)score.readUTF("name", Function.identity())).objective((String)score.readUTF("objective", Function.identity()));
        } else if (selector != null) {
            SelectorComponent.Builder builder = Component.selector().pattern(selector).separator(separator);
        } else if (keybind != null) {
            KeybindComponent.Builder builder = Component.keybind().keybind(keybind);
        } else {
            if (nbt2 == null) throw new IllegalStateException("Illegal nbt component, component type could not be determined");
            if (nbtBlock != null) {
                BlockNBTComponent.Builder builder = ((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)Component.blockNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).pos(nbtBlock);
            } else if (nbtEntity != null) {
                EntityNBTComponent.Builder builder = ((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).selector(nbtEntity);
            } else {
                if (nbtStorage == null) throw new IllegalStateException("Illegal nbt component, block/entity/storage is missing");
                StorageNBTComponent.Builder builder = ((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)Component.storageNBT().nbtPath(nbt2)).interpret(nbtInterpret)).separator(separator)).storage(nbtStorage);
            }
        }
        var20_28.style(style);
        if (extra == null) return var20_28.build();
        var20_28.append(extra);
        return var20_28.build();
    }

    @Override
    @NotNull
    public NBT serialize(@NotNull Component component) {
        if (component instanceof TextComponent && !component.hasStyling() && component.children().isEmpty()) {
            return new NBTString(((TextComponent)component).content());
        }
        return this.serializeComponent(component);
    }

    @NotNull
    private NBTCompound serializeComponent(Component component) {
        List<Component> children;
        NBTWriter writer = new NBTWriter(new NBTCompound());
        if (component instanceof TextComponent) {
            writer.writeUTF("text", ((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            List<Component> args;
            String fallback;
            writer.writeUTF("translate", ((TranslatableComponent)component).key());
            if (BackwardCompatUtil.IS_4_13_0_OR_NEWER && (fallback = ((TranslatableComponent)component).fallback()) != null) {
                writer.writeUTF("fallback", fallback);
            }
            if (!(args = ((TranslatableComponent)component).args()).isEmpty()) {
                if (BackwardCompatUtil.IS_4_15_0_OR_NEWER) {
                    writer.writeList("with", NBTType.COMPOUND, this.serializeTranslationArgumentList(((TranslatableComponent)component).arguments()));
                } else {
                    writer.writeList("with", NBTType.COMPOUND, this.serializeComponentList(args));
                }
            }
        } else if (component instanceof ScoreComponent) {
            NBTWriter score = writer.child("score");
            String scoreName = ((ScoreComponent)component).name();
            score.writeUTF("name", scoreName);
            String scoreObjective = ((ScoreComponent)component).objective();
            score.writeUTF("objective", scoreObjective);
        } else if (component instanceof SelectorComponent) {
            writer.writeUTF("selector", ((SelectorComponent)component).pattern());
            Component separator = ((SelectorComponent)component).separator();
            if (separator != null) {
                writer.write("separator", this.serialize(separator));
            }
        } else if (component instanceof KeybindComponent) {
            writer.writeUTF("keybind", ((KeybindComponent)component).keybind());
        } else if (component instanceof NBTComponent) {
            Component separator;
            String nbtPath = ((NBTComponent)component).nbtPath();
            writer.writeUTF("nbt", nbtPath);
            boolean interpret = ((NBTComponent)component).interpret();
            if (interpret) {
                writer.writeBoolean("interpret", true);
            }
            if ((separator = ((NBTComponent)component).separator()) != null) {
                writer.write("separator", this.serialize(separator));
            }
            if (component instanceof BlockNBTComponent) {
                BlockNBTComponent.Pos pos = ((BlockNBTComponent)component).pos();
                writer.writeUTF("block", pos.asString());
            } else if (component instanceof EntityNBTComponent) {
                String selector = ((EntityNBTComponent)component).selector();
                writer.writeUTF("entity", selector);
            } else if (component instanceof StorageNBTComponent) {
                Key storage = ((StorageNBTComponent)component).storage();
                writer.writeUTF("storage", storage.asString());
            }
        }
        if (component.hasStyling()) {
            this.serializeStyle(component.style()).getTags().forEach(writer::write);
        }
        if (!(children = component.children()).isEmpty()) {
            writer.writeList("extra", NBTType.COMPOUND, this.serializeComponentList(children));
        }
        return writer.compound;
    }

    @NotNull
    public Style deserializeStyle(NBTCompound input) {
        NBTReader hoverEvent;
        if (input.isEmpty()) {
            return Style.empty();
        }
        Style.Builder style = Style.style();
        NBTReader reader = new NBTReader(input);
        reader.useUTF("font", value -> style.font(Key.key(value)));
        reader.useUTF("color", value -> {
            TextColor color = this.deserializeColor((String)value);
            if (color != null) {
                style.color(color);
            }
        });
        for (String decorationKey : TextDecoration.NAMES.keys()) {
            reader.useBoolean(decorationKey, value -> style.decoration(AdventureIndexUtil.indexValueOrThrow(TextDecoration.NAMES, decorationKey), TextDecoration.State.byBoolean(value)));
        }
        reader.useUTF("insertion", style::insertion);
        NBTReader clickEvent = reader.child("clickEvent");
        if (clickEvent != null) {
            style.clickEvent(ClickEvent.clickEvent(clickEvent.readUTF("action", ClickEvent.Action.NAMES::value), (String)clickEvent.readUTF("value", Function.identity())));
        }
        if ((hoverEvent = reader.child("hoverEvent")) != null) {
            HoverEvent.Action action = hoverEvent.readUTF("action", HoverEvent.Action.NAMES::value);
            if (action.equals(HoverEvent.Action.SHOW_TEXT)) {
                style.hoverEvent(HoverEvent.showText(hoverEvent.read("contents", this::deserialize)));
            } else if (action.equals(HoverEvent.Action.SHOW_ITEM)) {
                if (hoverEvent.type("contents") == NBTType.STRING) {
                    style.hoverEvent(HoverEvent.showItem(hoverEvent.readUTF("contents", Key::key), 1));
                } else {
                    NBTReader child = hoverEvent.child("contents");
                    Key itemId = child.readUTF("id", Key::key);
                    Integer count = child.readNumber("count", Number::intValue);
                    int nonNullCount = count == null ? 1 : count;
                    BinaryTagHolder tag = child.readUTF("tag", BinaryTagHolder::binaryTagHolder);
                    if (tag != null || !BackwardCompatUtil.IS_4_17_0_OR_NEWER) {
                        style.hoverEvent(HoverEvent.showItem(itemId, nonNullCount, tag));
                    } else {
                        Map components = child.readCompound("components", nbt -> {
                            HashMap<Key, DataComponentValue> map = new HashMap<Key, DataComponentValue>(nbt.size());
                            for (Map.Entry<String, NBT> entry : nbt.getTags().entrySet()) {
                                Key key;
                                if (entry.getKey().startsWith("!")) {
                                    key = Key.key(entry.getKey().substring(1));
                                    map.put(key, DataComponentValue.removed());
                                    continue;
                                }
                                key = Key.key(entry.getKey());
                                map.put(key, new NbtComponentValue(entry.getValue()));
                            }
                            return map;
                        });
                        style.hoverEvent(HoverEvent.showItem((Keyed)itemId, nonNullCount, components == null ? Collections.emptyMap() : components));
                    }
                }
            } else if (action.equals(HoverEvent.Action.SHOW_ENTITY)) {
                NBTReader child = hoverEvent.child("contents");
                style.hoverEvent(HoverEvent.showEntity(child.readUTF("type", Key::key), child.readIntArray("id", UniqueIdUtil::fromIntArray), child.read("name", this::deserialize)));
            }
        }
        return style.build();
    }

    @NotNull
    public NBTCompound serializeStyle(Style style) {
        HoverEvent<?> hoverEvent;
        ClickEvent clickEvent;
        TextColor color;
        if (style.isEmpty()) {
            return new NBTCompound();
        }
        NBTWriter writer = new NBTWriter(new NBTCompound());
        Key font = style.font();
        if (font != null) {
            writer.writeUTF("font", font.asString());
        }
        if ((color = style.color()) != null) {
            writer.writeUTF("color", this.serializeColor(color));
        }
        for (TextDecoration decoration : TextDecoration.NAMES.values()) {
            TextDecoration.State state = style.decoration(decoration);
            if (state == TextDecoration.State.NOT_SET) continue;
            writer.writeBoolean(decoration.toString(), state == TextDecoration.State.TRUE);
        }
        String insertion = style.insertion();
        if (insertion != null) {
            writer.writeUTF("insertion", insertion);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            NBTWriter child = writer.child("clickEvent");
            child.writeUTF("action", clickEvent.action().toString());
            child.writeUTF("value", clickEvent.value());
        }
        if ((hoverEvent = style.hoverEvent()) != null) {
            NBTWriter child = writer.child("hoverEvent");
            child.writeUTF("action", hoverEvent.action().toString());
            switch (hoverEvent.action().toString()) {
                case "show_text": {
                    child.write("contents", this.serialize((Component)hoverEvent.value()));
                    break;
                }
                case "show_item": {
                    boolean emptyComps;
                    HoverEvent.ShowItem item = (HoverEvent.ShowItem)hoverEvent.value();
                    Key itemId = item.item();
                    int count = item.count();
                    BinaryTagHolder nbt = item.nbt();
                    boolean bl = emptyComps = !BackwardCompatUtil.IS_4_17_0_OR_NEWER || item.dataComponents().isEmpty();
                    if (count == 1 && nbt == null && emptyComps) {
                        child.writeUTF("contents", itemId.asString());
                        break;
                    }
                    NBTWriter itemNBT = child.child("contents");
                    itemNBT.writeUTF("id", itemId.asString());
                    itemNBT.writeInt("count", count);
                    if (nbt != null) {
                        itemNBT.writeUTF("tag", nbt.string());
                    }
                    if (emptyComps) break;
                    NBTWriter compsNbt = itemNBT.child("components");
                    for (Map.Entry<Key, DataComponentValue> entry : item.dataComponents().entrySet()) {
                        if (entry.getValue() == DataComponentValue.removed()) {
                            compsNbt.writeCompound("!" + entry.getKey(), new NBTCompound());
                            continue;
                        }
                        if (!(entry.getValue() instanceof NbtComponentValue)) continue;
                        NBT compNbt = ((NbtComponentValue)entry.getValue()).nbt;
                        compsNbt.write(entry.getKey().toString(), compNbt);
                    }
                    break;
                }
                case "show_entity": {
                    HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
                    NBTWriter entity = child.child("contents");
                    entity.writeUTF("type", showEntity.type().asString());
                    entity.writeIntArray("id", UniqueIdUtil.toIntArray(showEntity.id()));
                    if (showEntity.name() == null) break;
                    entity.write("name", this.serialize(showEntity.name()));
                    break;
                }
            }
        }
        return writer.compound;
    }

    @Nullable
    private TextColor deserializeColor(@NotNull String value) {
        TextColor color = value.startsWith("#") ? TextColor.fromHexString(value) : (TextColor)NamedTextColor.NAMES.value(value);
        if (color == null) {
            return null;
        }
        return this.downsampleColor ? NamedTextColor.nearestTo(color) : color;
    }

    @NotNull
    private String serializeColor(@NotNull TextColor value) {
        if (value instanceof NamedTextColor) {
            return NamedTextColor.NAMES.key((NamedTextColor)value);
        }
        if (this.downsampleColor) {
            return NamedTextColor.NAMES.key(NamedTextColor.nearestTo(value));
        }
        return String.format(Locale.ROOT, "%c%06X", Character.valueOf('#'), value.value());
    }

    @NotNull
    private List<Component> deserializeComponentList(List<?> value) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>(value.size());
        for (Object nbt : value) {
            components.add(this.deserialize((NBT)nbt));
        }
        return components;
    }

    private List<NBTCompound> serializeComponentList(List<Component> value) {
        ArrayList<NBTCompound> components = new ArrayList<NBTCompound>(value.size());
        for (Component component : value) {
            components.add(this.serializeComponent(component));
        }
        return components;
    }

    @NotNull
    private List<TranslationArgument> deserializeTranslationArgumentList(List<?> value) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TranslationArgument> arguments = new ArrayList<TranslationArgument>(value.size());
        for (Object nbt : value) {
            if (nbt instanceof NBTByte) {
                arguments.add(TranslationArgument.bool(((NBTByte)nbt).getAsByte() != 0));
                continue;
            }
            if (nbt instanceof NBTNumber) {
                arguments.add(TranslationArgument.numeric(((NBTNumber)nbt).getAsInt()));
                continue;
            }
            if (nbt instanceof NBTString) {
                arguments.add(TranslationArgument.component(Component.text(((NBTString)nbt).getValue())));
                continue;
            }
            arguments.add(TranslationArgument.component(this.deserialize(AdventureNBTSerializer.requireType((NBT)nbt, NBTType.COMPOUND))));
        }
        return arguments;
    }

    private List<NBTCompound> serializeTranslationArgumentList(List<TranslationArgument> value) {
        ArrayList<NBTCompound> arguments = new ArrayList<NBTCompound>(value.size());
        for (TranslationArgument argument : value) {
            arguments.add(this.serializeComponent(argument.asComponent()));
        }
        return arguments;
    }

    private static <T extends NBT> T requireType(NBT nbt, NBTType<T> required) {
        if (nbt.getType() != required) {
            throw new IllegalArgumentException("Expected " + required + " but got " + nbt.getType());
        }
        return (T)nbt;
    }

    static class NBTReader {
        private final NBTCompound compound;

        public NBTReader(NBTCompound compound) {
            this.compound = compound;
        }

        public void useBoolean(String key, Consumer<Boolean> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTByte)AdventureNBTSerializer.requireType(tag, NBTType.BYTE)).getAsByte() != 0));
        }

        public <R> R readBoolean(String key, Function<Boolean, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTByte)AdventureNBTSerializer.requireType(tag, NBTType.BYTE)).getAsByte() != 0));
        }

        public void useByte(String key, Consumer<Byte> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTByte)AdventureNBTSerializer.requireType(tag, NBTType.BYTE)).getAsByte()));
        }

        public <R> R readByte(String key, Function<Byte, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTByte)AdventureNBTSerializer.requireType(tag, NBTType.BYTE)).getAsByte()));
        }

        public void useShort(String key, Consumer<Short> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTShort)AdventureNBTSerializer.requireType(tag, NBTType.SHORT)).getAsShort()));
        }

        public <R> R readShort(String key, Function<Short, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTShort)AdventureNBTSerializer.requireType(tag, NBTType.SHORT)).getAsShort()));
        }

        public void useNumber(String key, Consumer<Number> consumer) {
            this.useTag(key, tag -> {
                if (!(tag instanceof NBTNumber)) {
                    throw new IllegalArgumentException("Expected number but got " + tag.getType());
                }
                consumer.accept(((NBTNumber)tag).getAsNumber());
            });
        }

        public <R> R readNumber(String key, Function<Number, R> function) {
            return (R)this.withTag(key, tag -> {
                if (tag instanceof NBTNumber) {
                    return function.apply(((NBTNumber)tag).getAsNumber());
                }
                throw new IllegalArgumentException("Expected number but got " + tag.getType());
            });
        }

        public void useUTF(String key, Consumer<String> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTString)AdventureNBTSerializer.requireType(tag, NBTType.STRING)).getValue()));
        }

        public <R> R readUTF(String key, Function<String, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTString)AdventureNBTSerializer.requireType(tag, NBTType.STRING)).getValue()));
        }

        public void useByteArray(String key, Consumer<byte[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTByteArray)AdventureNBTSerializer.requireType(tag, NBTType.BYTE_ARRAY)).getValue()));
        }

        public <R> R readByteArray(String key, Function<byte[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTByteArray)AdventureNBTSerializer.requireType(tag, NBTType.BYTE_ARRAY)).getValue()));
        }

        public void useIntArray(String key, Consumer<int[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTIntArray)AdventureNBTSerializer.requireType(tag, NBTType.INT_ARRAY)).getValue()));
        }

        public <R> R readIntArray(String key, Function<int[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTIntArray)AdventureNBTSerializer.requireType(tag, NBTType.INT_ARRAY)).getValue()));
        }

        public void useLongArray(String key, Consumer<long[]> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTLongArray)AdventureNBTSerializer.requireType(tag, NBTType.LONG_ARRAY)).getValue()));
        }

        public <R> R readLongArray(String key, Function<long[], R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTLongArray)AdventureNBTSerializer.requireType(tag, NBTType.LONG_ARRAY)).getValue()));
        }

        public void useCompound(String key, Consumer<NBTCompound> consumer) {
            this.useTag(key, tag -> consumer.accept((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public <R> R readCompound(String key, Function<NBTCompound, R> function) {
            return (R)this.withTag(key, tag -> function.apply((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public void useList(String key, Consumer<List<?>> consumer) {
            this.useTag(key, tag -> consumer.accept(((NBTList)AdventureNBTSerializer.requireType(tag, NBTType.LIST)).getTags()));
        }

        public <R> R readList(String key, Function<List<?>, R> function) {
            return (R)this.withTag(key, tag -> function.apply(((NBTList)AdventureNBTSerializer.requireType(tag, NBTType.LIST)).getTags()));
        }

        public void use(String key, Consumer<NBT> consumer) {
            this.useTag(key, consumer);
        }

        public <R> R read(String key, Function<NBT, R> function) {
            return this.withTag(key, function);
        }

        public NBTReader child(String key) {
            return this.withTag(key, tag -> new NBTReader((NBTCompound)AdventureNBTSerializer.requireType(tag, NBTType.COMPOUND)));
        }

        public NBTType<?> type(String key) {
            return this.withTag(key, NBT::getType);
        }

        private void useTag(String key, Consumer<NBT> consumer) {
            NBT tag = this.compound.getTagOrNull(key);
            if (tag != null) {
                consumer.accept(tag);
            }
        }

        private <R> R withTag(String key, Function<NBT, R> function) {
            NBT tag = this.compound.getTagOrNull(key);
            return tag == null ? null : (R)function.apply(tag);
        }
    }

    static class NBTWriter {
        private final NBTCompound compound;

        public NBTWriter(NBTCompound compound) {
            this.compound = compound;
        }

        public void writeBoolean(String key, boolean value) {
            this.compound.setTag(key, new NBTByte(value ? (byte)1 : 0));
        }

        public void writeByte(String key, byte value) {
            this.compound.setTag(key, new NBTByte(value));
        }

        public void writeShort(String key, short value) {
            this.compound.setTag(key, new NBTShort(value));
        }

        public void writeInt(String key, int value) {
            this.compound.setTag(key, new NBTInt(value));
        }

        public void writeLong(String key, long value) {
            this.compound.setTag(key, new NBTLong(value));
        }

        public void writeFloat(String key, float value) {
            this.compound.setTag(key, new NBTFloat(value));
        }

        public void writeDouble(String key, double value) {
            this.compound.setTag(key, new NBTDouble(value));
        }

        public void writeUTF(String key, String value) {
            this.compound.setTag(key, new NBTString(value));
        }

        public void writeByteArray(String key, byte[] value) {
            this.compound.setTag(key, new NBTByteArray(value));
        }

        public void writeIntArray(String key, int[] value) {
            this.compound.setTag(key, new NBTIntArray(value));
        }

        public void writeLongArray(String key, long[] value) {
            this.compound.setTag(key, new NBTLongArray(value));
        }

        public <T extends NBT> void writeList(String key, NBTType<T> innerType, List<T> value) {
            this.compound.setTag(key, new NBTList<T>(innerType, value));
        }

        public void writeCompound(String key, NBTCompound value) {
            this.compound.setTag(key, value);
        }

        public void write(String key, NBT value) {
            this.compound.setTag(key, value);
        }

        public NBTWriter child(String key) {
            NBTCompound child = new NBTCompound();
            this.compound.setTag(key, child);
            return new NBTWriter(child);
        }
    }

    private static final class NbtComponentValue
    implements DataComponentValue {
        private final NBT nbt;

        public NbtComponentValue(NBT nbt) {
            this.nbt = nbt;
        }
    }
}

