/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.login.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.TextureProperty;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.UserProfile;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.UUID;

public class WrapperLoginServerLoginSuccess
extends PacketWrapper<WrapperLoginServerLoginSuccess> {
    private UserProfile userProfile;
    private boolean strictErrorHandling;

    public WrapperLoginServerLoginSuccess(PacketSendEvent event) {
        super(event);
    }

    public WrapperLoginServerLoginSuccess(UUID uuid, String username) {
        this(new UserProfile(uuid, username));
    }

    public WrapperLoginServerLoginSuccess(UserProfile userProfile) {
        this(userProfile, true);
    }

    public WrapperLoginServerLoginSuccess(UserProfile userProfile, boolean strictErrorHandling) {
        super(PacketType.Login.Server.LOGIN_SUCCESS);
        this.userProfile = userProfile;
        this.strictErrorHandling = strictErrorHandling;
    }

    @Override
    public void read() {
        UUID uuid = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16) ? this.readUUID() : UUID.fromString(this.readString(36));
        String username = this.readString(16);
        this.userProfile = new UserProfile(uuid, username);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            int propertyCount = this.readVarInt();
            for (int i = 0; i < propertyCount; ++i) {
                String propertyName = this.readString();
                String propertyValue = this.readString();
                String propertySignature = (String)this.readOptional(PacketWrapper::readString);
                TextureProperty textureProperty = new TextureProperty(propertyName, propertyValue, propertySignature);
                this.userProfile.getTextureProperties().add(textureProperty);
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            this.strictErrorHandling = this.readBoolean();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16)) {
            this.writeUUID(this.userProfile.getUUID());
        } else {
            this.writeString(this.userProfile.getUUID().toString(), 36);
        }
        this.writeString(this.userProfile.getName(), 16);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19)) {
            this.writeVarInt(this.userProfile.getTextureProperties().size());
            for (TextureProperty textureProperty : this.userProfile.getTextureProperties()) {
                this.writeString(textureProperty.getName());
                this.writeString(textureProperty.getValue());
                this.writeOptional(textureProperty.getSignature(), PacketWrapper::writeString);
            }
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
            this.writeBoolean(this.strictErrorHandling);
        }
    }

    @Override
    public void copy(WrapperLoginServerLoginSuccess wrapper) {
        this.userProfile = wrapper.userProfile;
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void setUserProfile(UserProfile userProfile) {
        this.userProfile = userProfile;
    }

    public boolean isStrictErrorHandling() {
        return this.strictErrorHandling;
    }

    public void setStrictErrorHandling(boolean strictErrorHandling) {
        this.strictErrorHandling = strictErrorHandling;
    }
}

