/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3d;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerEntityVelocity
extends PacketWrapper<WrapperPlayServerEntityVelocity> {
    private int entityID;
    private Vector3d velocity;

    public WrapperPlayServerEntityVelocity(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityVelocity(int entityID, Vector3d velocity) {
        super(PacketType.Play.Server.ENTITY_VELOCITY);
        this.entityID = entityID;
        this.velocity = velocity;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion == ServerVersion.V_1_7_10 ? this.readInt() : this.readVarInt();
        double velX = (double)this.readShort() / 8000.0;
        double velY = (double)this.readShort() / 8000.0;
        double velZ = (double)this.readShort() / 8000.0;
        this.velocity = new Vector3d(velX, velY, velZ);
    }

    @Override
    public void write() {
        if (this.serverVersion == ServerVersion.V_1_7_10) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        this.writeShort((int)(this.velocity.x * 8000.0));
        this.writeShort((int)(this.velocity.y * 8000.0));
        this.writeShort((int)(this.velocity.z * 8000.0));
    }

    @Override
    public void copy(WrapperPlayServerEntityVelocity wrapper) {
        this.entityID = wrapper.entityID;
        this.velocity = wrapper.velocity;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3d velocity) {
        this.velocity = velocity;
    }
}

