/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.Particle;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.data.ParticleData;
import info.cho.passwords.fairy.libs.packetevents.protocol.particle.type.ParticleTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.sound.Sound;
import info.cho.passwords.fairy.libs.packetevents.protocol.sound.StaticSound;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3d;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3f;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3i;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerExplosion
extends PacketWrapper<WrapperPlayServerExplosion> {
    private Vector3d position;
    private float strength;
    private List<Vector3i> records;
    private Vector3f playerMotion;
    private Particle<?> smallExplosionParticles;
    private Particle<?> largeExplosionParticles;
    private BlockInteraction blockInteraction;
    private Sound explosionSound;

    public WrapperPlayServerExplosion(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion) {
        this(position, strength, records, playerMotion, new Particle<ParticleData>(ParticleTypes.EXPLOSION), new Particle<ParticleData>(ParticleTypes.EXPLOSION_EMITTER), BlockInteraction.DESTROY_BLOCKS, new ResourceLocation("minecraft:entity.generic.explode"), null);
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallExplosionParticles, Particle<?> largeExplosionParticles, BlockInteraction blockInteraction, ResourceLocation explosionSoundKey, @Nullable Float explosionSoundRange) {
        this(position, strength, records, playerMotion, smallExplosionParticles, largeExplosionParticles, blockInteraction, new StaticSound(explosionSoundKey, explosionSoundRange));
    }

    public WrapperPlayServerExplosion(Vector3d position, float strength, List<Vector3i> records, Vector3f playerMotion, Particle<?> smallExplosionParticles, Particle<?> largeExplosionParticles, BlockInteraction blockInteraction, Sound explosionSound) {
        super(PacketType.Play.Server.EXPLOSION);
        this.position = position;
        this.strength = strength;
        this.records = records;
        this.playerMotion = playerMotion;
        this.smallExplosionParticles = smallExplosionParticles;
        this.largeExplosionParticles = largeExplosionParticles;
        this.blockInteraction = blockInteraction;
        this.explosionSound = explosionSound;
    }

    @Override
    public void read() {
        this.position = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3) ? new Vector3d(this.readDouble(), this.readDouble(), this.readDouble()) : new Vector3d(this.readFloat(), this.readFloat(), this.readFloat());
        this.strength = this.readFloat();
        int recordsLength = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) ? this.readVarInt() : this.readInt();
        this.records = new ArrayList<Vector3i>(recordsLength);
        Vector3i floor = this.toFloor(this.position);
        for (int i = 0; i < recordsLength; ++i) {
            int chunkPosX = this.readByte() + floor.getX();
            int chunkPosY = this.readByte() + floor.getY();
            int chunkPosZ = this.readByte() + floor.getZ();
            this.records.add(new Vector3i(chunkPosX, chunkPosY, chunkPosZ));
        }
        float motX = this.readFloat();
        float motY = this.readFloat();
        float motZ = this.readFloat();
        this.playerMotion = new Vector3f(motX, motY, motZ);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.blockInteraction = BlockInteraction.values()[this.readVarInt()];
            this.smallExplosionParticles = Particle.read(this);
            this.largeExplosionParticles = Particle.read(this);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                this.explosionSound = Sound.read(this);
            } else {
                ResourceLocation explosionSoundKey = this.readIdentifier();
                Float explosionSoundRange = (Float)this.readOptional(PacketWrapper::readFloat);
                this.explosionSound = new StaticSound(explosionSoundKey, explosionSoundRange);
            }
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3)) {
            this.writeDouble(this.position.getX());
            this.writeDouble(this.position.getY());
            this.writeDouble(this.position.getZ());
        } else {
            this.writeFloat((float)this.position.getX());
            this.writeFloat((float)this.position.getY());
            this.writeFloat((float)this.position.getZ());
        }
        this.writeFloat(this.strength);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeVarInt(this.records.size());
        } else {
            this.writeInt(this.records.size());
        }
        Vector3i floor = this.toFloor(this.position);
        for (Vector3i record : this.records) {
            this.writeByte(record.x - floor.getX());
            this.writeByte(record.y - floor.getY());
            this.writeByte(record.z - floor.getZ());
        }
        this.writeFloat(this.playerMotion.x);
        this.writeFloat(this.playerMotion.y);
        this.writeFloat(this.playerMotion.z);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_3)) {
            this.writeVarInt(this.blockInteraction.ordinal());
            Particle.write(this, this.smallExplosionParticles);
            Particle.write(this, this.largeExplosionParticles);
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                Sound.write(this, this.explosionSound);
            } else {
                this.writeIdentifier(this.explosionSound.getSoundId());
                this.writeOptional(this.explosionSound.getRange(), PacketWrapper::writeFloat);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerExplosion wrapper) {
        this.position = wrapper.position;
        this.strength = wrapper.strength;
        this.records = wrapper.records;
        this.playerMotion = wrapper.playerMotion;
        this.smallExplosionParticles = wrapper.smallExplosionParticles;
        this.largeExplosionParticles = wrapper.largeExplosionParticles;
        this.blockInteraction = wrapper.blockInteraction;
        this.explosionSound = wrapper.explosionSound;
    }

    private Vector3i toFloor(Vector3d position) {
        int floorZ;
        int floorY;
        int floorX;
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14)) {
            floorX = (int)Math.floor(position.x);
            floorY = (int)Math.floor(position.y);
            floorZ = (int)Math.floor(position.z);
        } else {
            floorX = (int)position.x;
            floorY = (int)position.y;
            floorZ = (int)position.z;
        }
        return new Vector3i(floorX, floorY, floorZ);
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        this.position = position;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public List<Vector3i> getRecords() {
        return this.records;
    }

    public void setRecords(List<Vector3i> records) {
        this.records = records;
    }

    public Vector3f getPlayerMotion() {
        return this.playerMotion;
    }

    public void setPlayerMotion(Vector3f playerMotion) {
        this.playerMotion = playerMotion;
    }

    public Particle<?> getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public void setSmallExplosionParticles(Particle<?> smallExplosionParticles) {
        this.smallExplosionParticles = smallExplosionParticles;
    }

    public Particle<?> getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public void setLargeExplosionParticles(Particle<?> largeExplosionParticles) {
        this.largeExplosionParticles = largeExplosionParticles;
    }

    public BlockInteraction getBlockInteraction() {
        return this.blockInteraction;
    }

    public void setBlockInteraction(BlockInteraction blockInteraction) {
        this.blockInteraction = blockInteraction;
    }

    public ResourceLocation getExplosionSoundKey() {
        return this.explosionSound.getSoundId();
    }

    public void setExplosionSoundKey(ResourceLocation explosionSoundKey) {
        this.explosionSound = new StaticSound(explosionSoundKey, this.explosionSound.getRange());
    }

    @Nullable
    public Float getExplosionSoundRange() {
        return this.explosionSound.getRange();
    }

    public void setExplosionSoundRange(@Nullable Float explosionSoundRange) {
        this.explosionSound = new StaticSound(this.explosionSound.getSoundId(), explosionSoundRange);
    }

    public Sound getExplosionSound() {
        return this.explosionSound;
    }

    public void setExplosionSound(Sound explosionSound) {
        this.explosionSound = explosionSound;
    }

    public static enum BlockInteraction {
        KEEP_BLOCKS,
        DESTROY_BLOCKS,
        DECAY_DESTROYED_BLOCKS,
        TRIGGER_BLOCKS;

    }
}

