/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.packetevents.wrapper.play.server;

import info.cho.passwords.fairy.libs.packetevents.event.PacketSendEvent;
import info.cho.passwords.fairy.libs.packetevents.manager.server.ServerVersion;
import info.cho.passwords.fairy.libs.packetevents.protocol.packettype.PacketType;
import info.cho.passwords.fairy.libs.packetevents.protocol.player.GameMode;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.Difficulty;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.Dimension;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.WorldBlockPosition;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.WorldType;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.dimension.DimensionType;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.dimension.DimensionTypeRef;
import info.cho.passwords.fairy.libs.packetevents.protocol.world.dimension.DimensionTypes;
import info.cho.passwords.fairy.libs.packetevents.resources.ResourceLocation;
import info.cho.passwords.fairy.libs.packetevents.util.mappings.IRegistry;
import info.cho.passwords.fairy.libs.packetevents.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerRespawn
extends PacketWrapper<WrapperPlayServerRespawn> {
    public static final byte KEEP_NOTHING = 0;
    public static final byte KEEP_ATTRIBUTES = 1;
    public static final byte KEEP_ENTITY_DATA = 2;
    public static final byte KEEP_ALL_DATA = 3;
    private DimensionTypeRef dimensionTypeRef;
    private Optional<String> worldName;
    private Difficulty difficulty;
    private long hashedSeed;
    private GameMode gameMode;
    @Nullable
    private GameMode previousGameMode;
    private boolean worldDebug;
    private boolean worldFlat;
    private byte keptData;
    private WorldBlockPosition lastDeathPosition;
    private Integer portalCooldown;
    private String levelType;

    public WrapperPlayServerRespawn(PacketSendEvent event) {
        super(event);
    }

    @Deprecated
    public WrapperPlayServerRespawn(Dimension dimension, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, boolean keepingAllPlayerData, @Nullable ResourceLocation deathDimensionName, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        this(dimension.asDimensionTypeRef(), worldName, difficulty, hashedSeed, gameMode, previousGameMode, worldDebug, worldFlat, keepingAllPlayerData, deathDimensionName, lastDeathPosition, portalCooldown);
    }

    @Deprecated
    public WrapperPlayServerRespawn(Dimension dimension, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, byte keptData, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        this(dimension.asDimensionTypeRef(), worldName, difficulty, hashedSeed, gameMode, previousGameMode, worldDebug, worldFlat, keptData, lastDeathPosition, portalCooldown);
    }

    public WrapperPlayServerRespawn(DimensionType dimensionType, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, boolean keepingAllPlayerData, @Nullable ResourceLocation deathDimensionName, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        this((DimensionTypeRef)null, worldName, difficulty, hashedSeed, gameMode, previousGameMode, worldDebug, worldFlat, keepingAllPlayerData, deathDimensionName, lastDeathPosition, portalCooldown);
        this.dimensionTypeRef = dimensionType.asRef(this.serverVersion.toClientVersion());
    }

    public WrapperPlayServerRespawn(DimensionType dimensionType, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, byte keptData, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        this((DimensionTypeRef)null, worldName, difficulty, hashedSeed, gameMode, previousGameMode, worldDebug, worldFlat, keptData, lastDeathPosition, portalCooldown);
        this.dimensionTypeRef = dimensionType.asRef(this.serverVersion.toClientVersion());
    }

    public WrapperPlayServerRespawn(DimensionTypeRef dimensionTypeRef, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, boolean keepingAllPlayerData, @Nullable ResourceLocation deathDimensionName, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        this(dimensionTypeRef, worldName, difficulty, hashedSeed, gameMode, previousGameMode, worldDebug, worldFlat, keepingAllPlayerData ? (byte)3 : 0, lastDeathPosition, portalCooldown);
    }

    public WrapperPlayServerRespawn(DimensionTypeRef dimensionTypeRef, @Nullable String worldName, Difficulty difficulty, long hashedSeed, GameMode gameMode, @Nullable GameMode previousGameMode, boolean worldDebug, boolean worldFlat, byte keptData, @Nullable WorldBlockPosition lastDeathPosition, @Nullable Integer portalCooldown) {
        super(PacketType.Play.Server.RESPAWN);
        this.dimensionTypeRef = dimensionTypeRef;
        this.setWorldName(worldName);
        this.difficulty = difficulty;
        this.hashedSeed = hashedSeed;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.worldDebug = worldDebug;
        this.worldFlat = worldFlat;
        this.keptData = keptData;
        this.lastDeathPosition = lastDeathPosition;
        this.portalCooldown = portalCooldown;
    }

    @Override
    public void read() {
        boolean v1_14 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        boolean v1_15_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15);
        boolean v1_16_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16);
        boolean v1_19 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        boolean v1_19_3 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3);
        boolean v1_20_2 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_2);
        this.dimensionTypeRef = DimensionTypeRef.read(this);
        if (v1_16_0) {
            this.worldName = Optional.of(this.readString());
            this.hashedSeed = this.readLong();
            this.gameMode = v1_20_2 ? this.readGameMode() : GameMode.getById(this.readUnsignedByte());
            this.previousGameMode = this.readGameMode();
            this.worldDebug = this.readBoolean();
            this.worldFlat = this.readBoolean();
            if (v1_19_3) {
                if (!v1_20_2) {
                    this.keptData = this.readByte();
                }
            } else {
                this.keptData = (byte)(this.readBoolean() ? 3 : 2);
            }
            if (v1_19) {
                this.lastDeathPosition = (WorldBlockPosition)this.readOptional(PacketWrapper::readWorldBlockPosition);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20)) {
                this.portalCooldown = this.readVarInt();
            }
            if (v1_20_2) {
                this.keptData = this.readByte();
            }
        } else {
            this.worldName = Optional.empty();
            this.hashedSeed = 0L;
            if (v1_15_0) {
                this.hashedSeed = this.readLong();
            } else if (!v1_14) {
                this.difficulty = Difficulty.getById(this.readByte());
            }
            this.gameMode = GameMode.getById(this.readByte());
            this.levelType = this.readString(16);
            this.worldFlat = info.cho.passwords.fairy.libs.packetevents.protocol.world.DimensionType.isFlat(this.levelType);
            this.worldDebug = info.cho.passwords.fairy.libs.packetevents.protocol.world.DimensionType.isDebug(this.levelType);
        }
    }

    @Override
    public void write() {
        boolean v1_14 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14);
        boolean v1_15_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_15);
        boolean v1_16_0 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_16);
        boolean v1_19 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19);
        boolean v1_19_3 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_3);
        boolean v1_20_2 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20_2);
        DimensionTypeRef.write(this, this.dimensionTypeRef);
        if (v1_16_0) {
            this.writeString(this.worldName.orElse(""));
            this.writeLong(this.hashedSeed);
            this.writeGameMode(this.gameMode);
            this.writeGameMode(this.previousGameMode);
            this.writeBoolean(this.worldDebug);
            this.writeBoolean(this.worldFlat);
            if (v1_19_3) {
                if (!v1_20_2) {
                    this.writeByte(this.keptData);
                }
            } else {
                this.writeBoolean((this.keptData & 1) != 0);
            }
            if (v1_19) {
                this.writeOptional(this.lastDeathPosition, PacketWrapper::writeWorldBlockPosition);
            }
            if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_20)) {
                int pCooldown = this.portalCooldown != null ? this.portalCooldown : 0;
                this.writeVarInt(pCooldown);
            }
            if (v1_20_2) {
                this.writeByte(this.keptData);
            }
        } else {
            if (v1_15_0) {
                this.writeLong(this.hashedSeed);
            } else if (!v1_14) {
                int id = this.difficulty == null ? Difficulty.NORMAL.getId() : this.difficulty.getId();
                this.writeByte(id);
            }
            this.writeByte(this.gameMode.ordinal());
            if (this.worldFlat) {
                this.writeString(WorldType.FLAT.getName());
            } else if (this.worldDebug) {
                this.writeString(WorldType.DEBUG_ALL_BLOCK_STATES.getName());
            } else {
                this.writeString(this.levelType == null ? WorldType.DEFAULT.getName() : this.levelType, 16);
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerRespawn wrapper) {
        this.dimensionTypeRef = wrapper.dimensionTypeRef;
        this.worldName = wrapper.worldName;
        this.difficulty = wrapper.difficulty;
        this.hashedSeed = wrapper.hashedSeed;
        this.gameMode = wrapper.gameMode;
        this.previousGameMode = wrapper.previousGameMode;
        this.worldDebug = wrapper.worldDebug;
        this.worldFlat = wrapper.worldFlat;
        this.keptData = wrapper.keptData;
        this.lastDeathPosition = wrapper.lastDeathPosition;
    }

    public DimensionTypeRef getDimensionTypeRef() {
        return this.dimensionTypeRef;
    }

    public void setDimensionTypeRef(DimensionTypeRef dimensionTypeRef) {
        this.dimensionTypeRef = dimensionTypeRef;
    }

    public DimensionType getDimensionType() {
        IRegistry<DimensionType> registry = this.getRegistryHolder().getRegistryOr(DimensionTypes.getRegistry());
        return this.dimensionTypeRef.resolve(registry, this.serverVersion.toClientVersion());
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionTypeRef = dimensionType.asRef(this.serverVersion.toClientVersion());
    }

    @Deprecated
    public Dimension getDimension() {
        return Dimension.fromDimensionTypeRef(this.dimensionTypeRef);
    }

    @Deprecated
    public void setDimension(Dimension dimension) {
        this.dimensionTypeRef = dimension.asDimensionTypeRef();
    }

    public Optional<String> getWorldName() {
        return this.worldName;
    }

    public void setWorldName(@Nullable String worldName) {
        this.worldName = Optional.ofNullable(worldName);
    }

    @Nullable
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public long getHashedSeed() {
        return this.hashedSeed;
    }

    public void setHashedSeed(long hashedSeed) {
        this.hashedSeed = hashedSeed;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
    }

    @Nullable
    public GameMode getPreviousGameMode() {
        return this.previousGameMode;
    }

    public void setPreviousGameMode(@Nullable GameMode previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public boolean isWorldDebug() {
        return this.worldDebug;
    }

    public void setWorldDebug(boolean worldDebug) {
        this.worldDebug = worldDebug;
    }

    public boolean isWorldFlat() {
        return this.worldFlat;
    }

    public void setWorldFlat(boolean worldFlat) {
        this.worldFlat = worldFlat;
    }

    public boolean isKeepingAllPlayerData() {
        return (this.keptData & 1) != 0;
    }

    public void setKeepingAllPlayerData(boolean keepAllPlayerData) {
        this.keptData = (byte)(keepAllPlayerData ? 3 : 2);
    }

    public byte getKeptData() {
        return this.keptData;
    }

    public void setKeptData(byte keptData) {
        this.keptData = keptData;
    }

    @Nullable
    public WorldBlockPosition getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(@Nullable WorldBlockPosition lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }

    public Optional<Integer> getPortalCooldown() {
        return Optional.ofNullable(this.portalCooldown);
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }
}

