/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.profiles;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import info.cho.passwords.fairy.libs.gson.Gson;
import info.cho.passwords.fairy.libs.gson.GsonBuilder;
import info.cho.passwords.fairy.libs.gson.JsonObject;
import info.cho.passwords.fairy.libs.gson.JsonParser;
import info.cho.passwords.fairy.libs.xseries.profiles.PlayerUUIDs;
import info.cho.passwords.fairy.libs.xseries.profiles.ProfilesCore;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PlayerProfiles {
    public static final String DEFAULT_PROFILE_NAME = "XSeries";
    private static final Property XSERIES_GAMEPROFILE_SIGNATURE = new Property("XSeries", "11.2.0");
    private static final String TEXTURES_PROPERTY = "textures";
    public static final GameProfile NIL = PlayerProfiles.createGameProfile(PlayerUUIDs.IDENTITY_UUID, "XSeries");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String TEXTURES_NBT_PROPERTY_PREFIX = "{\"textures\":{\"SKIN\":{\"url\":\"";
    public static final String TEXTURES_BASE_URL = "http://textures.minecraft.net/texture/";

    public static Optional<Property> getTextureProperty(GameProfile profile) {
        return Optional.ofNullable((Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)TEXTURES_PROPERTY), null));
    }

    @Nullable
    public static String getSkinValue(@Nonnull GameProfile profile) {
        Objects.requireNonNull(profile, "Game profile cannot be null");
        return PlayerProfiles.getTextureProperty(profile).map(PlayerProfiles::getPropertyValue).orElse(null);
    }

    public static String getPropertyValue(Property property) {
        if (ProfilesCore.NULLABILITY_RECORD_UPDATE) {
            return property.value();
        }
        try {
            return ProfilesCore.Property_getValue.invoke(property);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to get a property value: " + property, throwable);
        }
    }

    public static boolean hasTextures(GameProfile profile) {
        return PlayerProfiles.getTextureProperty(profile).isPresent();
    }

    @Nonnull
    public static GameProfile profileFromHashAndBase64(String hash, String base64) {
        UUID uuid = UUID.nameUUIDFromBytes(hash.getBytes(StandardCharsets.UTF_8));
        GameProfile profile = PlayerProfiles.createNamelessGameProfile(uuid);
        PlayerProfiles.setTexturesProperty(profile, base64);
        return profile;
    }

    public static void removeTimestamp(GameProfile profile) {
        JsonObject jsonObject = Optional.ofNullable(PlayerProfiles.getSkinValue(profile)).map(PlayerProfiles::decodeBase64).map(decoded -> new JsonParser().parse((String)decoded).getAsJsonObject()).orElse(null);
        if (jsonObject == null || !jsonObject.has("timestamp")) {
            return;
        }
        jsonObject.remove("timestamp");
        PlayerProfiles.setTexturesProperty(profile, PlayerProfiles.encodeBase64(GSON.toJson(jsonObject)));
    }

    public static GameProfile sanitizeProfile(GameProfile profile) {
        if (PlayerUUIDs.isOnlineMode()) {
            return profile;
        }
        UUID offlineId = PlayerUUIDs.getOfflineUUID(profile.getName());
        PlayerUUIDs.ONLINE_TO_OFFLINE.put(profile.getId(), offlineId);
        GameProfile clone = PlayerProfiles.createGameProfile(offlineId, profile.getName());
        clone.getProperties().putAll((Multimap)profile.getProperties());
        return clone;
    }

    public static GameProfile clone(GameProfile gameProfile) {
        GameProfile clone = new GameProfile(gameProfile.getId(), gameProfile.getName());
        clone.getProperties().putAll((Multimap)gameProfile.getProperties());
        return clone;
    }

    public static void setTexturesProperty(GameProfile profile, String texture) {
        Property property = new Property(TEXTURES_PROPERTY, texture);
        PropertyMap properties = profile.getProperties();
        properties.asMap().remove(TEXTURES_PROPERTY);
        properties.put((Object)TEXTURES_PROPERTY, (Object)property);
    }

    public static String encodeBase64(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    public static String decodeBase64(String base64) {
        Objects.requireNonNull(base64, "Cannot decode null string");
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static GameProfile createGameProfile(UUID uuid, String username) {
        return PlayerProfiles.signXSeries(new GameProfile(uuid, username));
    }

    public static GameProfile signXSeries(GameProfile profile) {
        PropertyMap properties = profile.getProperties();
        properties.put((Object)DEFAULT_PROFILE_NAME, (Object)XSERIES_GAMEPROFILE_SIGNATURE);
        return profile;
    }

    public static GameProfile createNamelessGameProfile(UUID id) {
        return PlayerProfiles.createGameProfile(id, DEFAULT_PROFILE_NAME);
    }
}

