/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.reflection;

import info.cho.passwords.fairy.libs.xseries.reflection.ReflectiveHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.XReflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregateReflectiveHandle<T, H extends ReflectiveHandle<T>>
implements ReflectiveHandle<T> {
    private final List<Callable<H>> handles;
    private Consumer<H> handleModifier;

    protected AggregateReflectiveHandle(Collection<Callable<H>> handles) {
        this.handles = new ArrayList<Callable<H>>(handles.size());
        this.handles.addAll(handles);
    }

    public AggregateReflectiveHandle<T, H> or(@Nonnull H handle) {
        return this.or(() -> handle);
    }

    public AggregateReflectiveHandle<T, H> or(@Nonnull Callable<H> handle) {
        this.handles.add(handle);
        return this;
    }

    public AggregateReflectiveHandle<T, H> modify(@Nullable Consumer<H> handleModifier) {
        this.handleModifier = handleModifier;
        return this;
    }

    public AggregateReflectiveHandle<T, H> clone() {
        AggregateReflectiveHandle<T, H> handle = new AggregateReflectiveHandle<T, H>(new ArrayList<Callable<H>>(this.handles));
        handle.handleModifier = this.handleModifier;
        return handle;
    }

    @Override
    public T reflect() throws ReflectiveOperationException {
        Throwable errors = null;
        for (Callable<H> handle : this.handles) {
            ReflectiveHandle handled;
            try {
                handled = (ReflectiveHandle)handle.call();
            }
            catch (Throwable ex) {
                if (errors == null) {
                    errors = new ClassNotFoundException("None of the aggregate handles were successful");
                }
                errors.addSuppressed(ex);
                continue;
            }
            if (this.handleModifier != null) {
                this.handleModifier.accept(handled);
            }
            try {
                return handled.reflect();
            }
            catch (Throwable ex) {
                if (errors == null) {
                    errors = new ClassNotFoundException("None of the aggregate handles were successful");
                }
                errors.addSuppressed(ex);
            }
        }
        throw (ClassNotFoundException)XReflection.relativizeSuppressedExceptions(errors);
    }
}

