/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.reflection.jvm;

import info.cho.passwords.fairy.libs.xseries.reflection.ReflectiveHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.XReflection;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.classes.ClassHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.minecraft.MinecraftMapping;
import info.cho.passwords.fairy.libs.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Pattern;

public class MethodMemberHandle
extends FlaggedNamedMemberHandle {
    protected Class<?>[] parameterTypes = new Class[0];

    public MethodMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    public MethodMemberHandle parameters(ClassHandle ... parameterTypes) {
        this.parameterTypes = (Class[])Arrays.stream(parameterTypes).map(ReflectiveHandle::unreflect).toArray(Class[]::new);
        return this;
    }

    @Override
    public MethodMemberHandle returns(Class<?> clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle returns(ClassHandle clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle asStatic() {
        super.asStatic();
        return this;
    }

    public MethodMemberHandle parameters(Class<?> ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        return this.clazz.getNamespace().getLookup().unreflect(this.reflectJvm());
    }

    @Override
    public MethodMemberHandle signature(String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseMethod(this);
    }

    @Override
    public MethodMemberHandle map(MinecraftMapping mapping, @Pattern(value="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String name) {
        super.map(mapping, name);
        return this;
    }

    @Override
    public MethodMemberHandle named(String ... names) {
        super.named(names);
        return this;
    }

    public Method reflectJvm() throws ReflectiveOperationException {
        Objects.requireNonNull(this.returnType, "Return type not specified");
        if (this.names.isEmpty()) {
            throw new IllegalStateException("No names specified");
        }
        Throwable errors = null;
        Method method = null;
        Class clazz = (Class)this.clazz.reflect();
        for (String name : this.names) {
            if (method != null) break;
            try {
                method = clazz.getDeclaredMethod(name, this.parameterTypes);
                if (method.getReturnType() == this.returnType) continue;
                throw new NoSuchMethodException("Method named '" + name + "' was found but the return types don't match: " + this.returnType + " != " + method);
            }
            catch (NoSuchMethodException ex) {
                method = null;
                if (errors == null) {
                    errors = new NoSuchMethodException("None of the methods were found for " + this);
                }
                errors.addSuppressed(ex);
            }
        }
        if (method == null) {
            throw (NoSuchMethodException)XReflection.relativizeSuppressedExceptions(errors);
        }
        return this.handleAccessible(method);
    }

    @Override
    public MethodMemberHandle clone() {
        MethodMemberHandle handle = new MethodMemberHandle(this.clazz);
        handle.returnType = this.returnType;
        handle.parameterTypes = this.parameterTypes;
        handle.isFinal = this.isFinal;
        handle.makeAccessible = this.makeAccessible;
        handle.names.addAll(this.names);
        return handle;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        if (this.makeAccessible) {
            str = str + "protected/private ";
        }
        if (this.isFinal) {
            str = str + "final ";
        }
        if (this.returnType != null) {
            str = str + this.returnType.getSimpleName() + ' ';
        }
        str = str + String.join((CharSequence)"/", this.names);
        str = str + '(' + Arrays.stream(this.parameterTypes).map(Class::getSimpleName).collect(Collectors.joining(", ")) + ')';
        return str + '}';
    }
}

