/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.libs.xseries.reflection.parser;

import info.cho.passwords.fairy.libs.xseries.reflection.ReflectiveHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.ReflectiveNamespace;
import info.cho.passwords.fairy.libs.xseries.reflection.XReflection;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.ConstructorMemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.FieldMemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.MemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.MethodMemberHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.classes.DynamicClassHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.jvm.classes.PackageHandle;
import info.cho.passwords.fairy.libs.xseries.reflection.minecraft.MinecraftPackage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ReflectionParser {
    private final String declaration;
    private Pattern pattern;
    private Matcher matcher;
    private ReflectiveNamespace namespace;
    private Map<String, Class<?>> cachedImports;
    private final Set<Flag> flags = EnumSet.noneOf(Flag.class);
    private static final PackageHandle[] PACKAGE_HANDLES = MinecraftPackage.values();
    @Language(value="RegExp")
    private static final String JAVA_TYPE_REGEX = "(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:<[.\\w<>\\[\\], ]+>)?((?:\\[])*)";
    private static final Map<String, Class<?>> PREDEFINED_TYPES = new HashMap();
    @Language(value="RegExp")
    private static final String GENERIC;
    @Language(value="RegExp")
    private static final String PACKAGE_REGEX = "(?:package\\s+(?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\s*;\\s*)?";
    @Language(value="RegExp")
    private static final String CLASS_TYPES = "(?<classType>class|interface|enum)";
    @Language(value="RegExp")
    private static final String PARAMETERS = "\\s*\\(\\s*(?<parameters>[\\w$_,. ]+)?\\s*\\)";
    @Language(value="RegExp")
    private static final String END_DECL = "\\s*;?\\s*";
    private static final Pattern CLASS;
    private static final Pattern METHOD;
    private static final Pattern CONSTRUCTOR;
    private static final Pattern FIELD;

    public ReflectionParser(@Language(value="Java") String declaration) {
        this.declaration = declaration;
    }

    @Language(value="RegExp")
    private static String id(@Language(value="RegExp") String groupName) {
        if (groupName == null) {
            return "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
        }
        return "(?<" + groupName + '>' + "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*" + ')';
    }

    @Language(value="RegExp")
    private static String type(@Language(value="RegExp") String groupName) {
        if (groupName == null) {
            return JAVA_TYPE_REGEX;
        }
        return "(?<" + groupName + '>' + JAVA_TYPE_REGEX + ')';
    }

    private Class<?>[] parseTypes(String[] typeNames) {
        Class[] classes = new Class[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            String typeName = typeNames[i];
            typeName = typeName.trim().substring(0, typeName.lastIndexOf(32)).trim();
            classes[i] = this.parseType(typeName);
        }
        return classes;
    }

    private Class<?> parseType(String typeName) {
        if (this.cachedImports == null && this.namespace != null) {
            this.cachedImports = this.namespace.getImports();
        }
        String firstTypeName = typeName;
        int arrayDimension = 0;
        if (typeName.endsWith("[]")) {
            String replaced = typeName.replace("[]", "");
            arrayDimension = (typeName.length() - replaced.length()) / 2;
            typeName = replaced;
        }
        if (typeName.endsWith(">")) {
            typeName = typeName.substring(0, typeName.indexOf(60));
        }
        Class clazz = null;
        if (!typeName.contains(".")) {
            if (this.cachedImports != null) {
                clazz = this.cachedImports.get(typeName);
            }
            if (clazz == null) {
                clazz = PREDEFINED_TYPES.get(typeName);
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            this.error("Unknown type '" + firstTypeName + "' -> '" + typeName + '\'');
        }
        if (arrayDimension != 0) {
            clazz = (Class)XReflection.of(clazz).asArray(arrayDimension).unreflect();
        }
        return clazz;
    }

    public ReflectionParser imports(ReflectiveNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    private void pattern(Pattern pattern, ReflectiveHandle<?> handle) {
        this.pattern = pattern;
        this.matcher = pattern.matcher(this.declaration);
        this.start(handle);
    }

    public <T extends DynamicClassHandle> T parseClass(T classHandle) {
        this.pattern(CLASS, classHandle);
        String packageName = this.group("package");
        if (packageName != null && !packageName.isEmpty()) {
            boolean found = false;
            for (PackageHandle pkgHandle : PACKAGE_HANDLES) {
                String targetPackageName = pkgHandle.packageId().toLowerCase(Locale.ENGLISH);
                if (!packageName.startsWith(targetPackageName)) continue;
                classHandle.inPackage(pkgHandle, packageName.substring(targetPackageName.length() + 1));
                found = true;
                break;
            }
            if (!found) {
                classHandle.inPackage(packageName);
            }
        }
        classHandle.named(this.group("className").split("\\$"));
        return classHandle;
    }

    public <T extends ConstructorMemberHandle> T parseConstructor(T ctorHandle) {
        this.pattern(CONSTRUCTOR, ctorHandle);
        if (this.has("className") && !ctorHandle.getClassHandle().getPossibleNames().contains(this.group("className"))) {
            this.error("Wrong class name associated to constructor, possible names: " + ctorHandle.getClassHandle().getPossibleNames());
        }
        if (this.has("parameters")) {
            ctorHandle.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return ctorHandle;
    }

    public <T extends MethodMemberHandle> T parseMethod(T methodHandle) {
        this.pattern(METHOD, methodHandle);
        methodHandle.named(this.group("methodName").split("\\$"));
        methodHandle.returns((Class)this.parseType(this.group("methodReturnType")));
        if (this.has("parameters")) {
            methodHandle.parameters(this.parseTypes(this.group("parameters").split(",")));
        }
        return methodHandle;
    }

    public <T extends FieldMemberHandle> T parseField(T fieldHandle) {
        this.pattern(FIELD, fieldHandle);
        fieldHandle.named(this.group("fieldName").split("\\$"));
        fieldHandle.returns((Class)this.parseType(this.group("fieldType")));
        return fieldHandle;
    }

    private String group(String groupName) {
        return this.matcher.group(groupName);
    }

    private boolean has(String groupName) {
        String group = this.group(groupName);
        return group != null && !group.isEmpty();
    }

    private void start(ReflectiveHandle<?> handle) {
        if (!this.matcher.matches()) {
            this.error("Not a " + handle + " declaration");
        }
        this.parseFlags();
        if (handle instanceof MemberHandle) {
            MemberHandle memberHandle = (MemberHandle)handle;
            if (!ReflectionParser.hasOneOf(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
                Class clazz = (Class)memberHandle.getClassHandle().reflectOrNull();
                if (clazz != null && !clazz.isInterface()) {
                    memberHandle.makeAccessible();
                }
            } else if (ReflectionParser.hasOneOf(this.flags, Flag.PRIVATE, Flag.PROTECTED)) {
                memberHandle.makeAccessible();
            }
            if (handle instanceof FieldMemberHandle && this.flags.contains((Object)Flag.FINAL)) {
                ((FieldMemberHandle)handle).asFinal();
            }
            if (handle instanceof FlaggedNamedMemberHandle && this.flags.contains((Object)Flag.STATIC)) {
                ((FlaggedNamedMemberHandle)handle).asStatic();
            }
        }
    }

    private void parseFlags() {
        if (!this.has("flags")) {
            return;
        }
        String flagsStr = this.group("flags");
        for (String flag : flagsStr.split("\\s+")) {
            if (this.flags.add(Flag.valueOf(flag.toUpperCase()))) continue;
            this.error("Repeated flag: " + flag);
        }
        if (ReflectionParser.containsDuplicates(this.flags, Flag.PUBLIC, Flag.PROTECTED, Flag.PRIVATE)) {
            this.error("Duplicate visibility flags");
        }
    }

    @SafeVarargs
    private static <T> boolean containsDuplicates(Collection<T> collection, T ... values) {
        boolean contained = false;
        for (T value : values) {
            if (!collection.contains(value)) continue;
            if (contained) {
                return true;
            }
            contained = true;
        }
        return false;
    }

    @SafeVarargs
    private static <T> boolean hasOneOf(Collection<T> collection, T ... elements) {
        return Arrays.stream(elements).anyMatch(collection::contains);
    }

    private void error(String message) {
        throw new RuntimeException(message + " in: " + this.declaration + " (RegEx: " + this.pattern.pattern() + "), (Imports: " + this.cachedImports + ')');
    }

    static {
        Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE, Void.TYPE, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class, Void.class, String.class, Optional.class, StringBuilder.class, StringBuffer.class, UUID.class, Map.class, HashMap.class, ConcurrentHashMap.class, LinkedHashMap.class, WeakHashMap.class, List.class, ArrayList.class, Set.class, HashSet.class, Deque.class, Queue.class, LinkedList.class, Date.class, Calendar.class, Duration.class).forEach(x -> PREDEFINED_TYPES.put(x.getSimpleName(), (Class<?>)x));
        GENERIC = "(?:<" + ReflectionParser.id(null) + ">)*";
        CLASS = Pattern.compile(PACKAGE_REGEX + Flag.FLAGS_REGEX + CLASS_TYPES + "\\s+" + ReflectionParser.id("className") + "(?:\\s+extends\\s+" + ReflectionParser.id("superclasses") + ")?\\s+(implements\\s+" + ReflectionParser.id("interfaces") + ")?(?:\\s*\\{\\s*})?\\s*");
        METHOD = Pattern.compile(Flag.FLAGS_REGEX + ReflectionParser.type("methodReturnType") + "\\s+" + ReflectionParser.id("methodName") + PARAMETERS + END_DECL);
        CONSTRUCTOR = Pattern.compile(Flag.FLAGS_REGEX + "\\s+" + ReflectionParser.id("className") + PARAMETERS + END_DECL);
        FIELD = Pattern.compile(Flag.FLAGS_REGEX + ReflectionParser.type("fieldType") + "\\s+" + ReflectionParser.id("fieldName") + END_DECL);
    }

    private static enum Flag {
        PUBLIC,
        PROTECTED,
        PRIVATE,
        FINAL,
        TRANSIENT,
        ABSTRACT,
        STATIC,
        NATIVE,
        SYNCHRONIZED,
        STRICTFP,
        VOLATILE;

        private static final String FLAGS_REGEX;

        static {
            FLAGS_REGEX = "(?<flags>(?:(?:" + Arrays.stream(Flag.values()).map(Enum::name).map(x -> x.toLowerCase(Locale.ENGLISH)).collect(Collectors.joining("|")) + ")\\s*)+)?";
        }
    }
}

