/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.hologram.entity.impl;

import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityData;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.data.EntityDataTypes;
import info.cho.passwords.fairy.libs.packetevents.protocol.entity.type.EntityTypes;
import info.cho.passwords.fairy.libs.packetevents.util.Vector3d;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerAttachEntity;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerEntityTeleport;
import info.cho.passwords.fairy.libs.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import info.cho.passwords.fairy.mc.MCAdventure;
import info.cho.passwords.fairy.mc.MCEntity;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.hologram.HologramImpl;
import info.cho.passwords.fairy.mc.hologram.entity.impl.AbstractHologramEntity;
import info.cho.passwords.fairy.mc.protocol.MCProtocol;
import info.cho.passwords.fairy.mc.util.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TextDisplayHologramEntity
extends AbstractHologramEntity {
    public TextDisplayHologramEntity(HologramImpl hologram) {
        super(hologram);
    }

    @Override
    public void show(MCPlayer player) {
        Position pos = this.hologram.getPosition();
        WrapperPlayServerSpawnEntity packet = new WrapperPlayServerSpawnEntity(this.entityId, Optional.of(this.entityUuid), EntityTypes.TEXT_DISPLAY, this.packetPosition(), pos.getPitch(), pos.getYaw(), pos.getYaw(), 0, Optional.of(new Vector3d()));
        MCProtocol.sendPacket(player, packet);
        this.update(player);
    }

    @Override
    public void update(MCPlayer player) {
        MCEntity attached = this.hologram.getAttached();
        WrapperPlayServerEntityTeleport packet = new WrapperPlayServerEntityTeleport(this.entityId, this.packetPosition(), this.hologram.getPosition().getPitch(), this.hologram.getPosition().getYaw(), false);
        WrapperPlayServerEntityMetadata metadataPacket = new WrapperPlayServerEntityMetadata(this.entityId, this.createEntityData(player));
        WrapperPlayServerAttachEntity attachEntityPacket = new WrapperPlayServerAttachEntity(this.entityId, attached != null ? attached.getId() : -1, false);
        MCProtocol.sendPacket(player, packet);
        MCProtocol.sendPacket(player, metadataPacket);
        MCProtocol.sendPacket(player, attachEntityPacket);
    }

    @Override
    public void hide(MCPlayer player) {
        WrapperPlayServerDestroyEntities packet = new WrapperPlayServerDestroyEntities(this.entityId);
        MCProtocol.sendPacket(player, packet);
    }

    private List<EntityData> createEntityData(MCPlayer mcPlayer) {
        ArrayList<EntityData> entityDataList = new ArrayList<EntityData>();
        entityDataList.add(new EntityData(22, EntityDataTypes.COMPONENT, MCAdventure.asItemString(this.line.render(mcPlayer), mcPlayer.getLocale())));
        entityDataList.add(new EntityData(23, EntityDataTypes.CAT_VARIANT, 200));
        entityDataList.add(new EntityData(24, EntityDataTypes.CAT_VARIANT, 0x40000000));
        entityDataList.add(new EntityData(25, EntityDataTypes.CAT_VARIANT, -1));
        boolean hasShadow = true;
        boolean isSeeThrough = false;
        boolean useDefaultBackgroundColor = true;
        int alignment = 0;
        entityDataList.add(new EntityData(26, EntityDataTypes.CAT_VARIANT, (hasShadow ? 1 : 0) | (isSeeThrough ? 2 : 0) | (useDefaultBackgroundColor ? 4 : 0) | alignment));
        return entityDataList;
    }
}

