/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.tablist;

import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.version.MCVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum TabColumn {
    LEFT(0, "Left", -2, 1, 3),
    MIDDLE(1, "Middle", -1, 21, 3),
    RIGHT(2, "Right", 0, 41, 3),
    FAR_RIGHT(3, "Far-Right", 60, 61, 1);

    private final int startNumber;
    private final int incrementBy;
    private final int rawStart;
    private final List<Integer> numbers = new ArrayList<Integer>();
    private final String identifier;
    private final int ordinal;

    private TabColumn(int ordinal, String identifier, int rawStart, int startNumber, int incrementBy) {
        this.ordinal = ordinal;
        this.identifier = identifier;
        this.rawStart = rawStart;
        this.startNumber = startNumber;
        this.incrementBy = incrementBy;
        this.generate();
    }

    public static TabColumn getColumn(String identifier) {
        for (TabColumn tabColumn : TabColumn.values()) {
            if (!tabColumn.getIdentifier().equalsIgnoreCase(identifier)) continue;
            return tabColumn;
        }
        return null;
    }

    private void generate() {
        for (int i = 1; i <= 20; ++i) {
            Integer numb = this.rawStart + i * this.incrementBy;
            this.numbers.add(numb);
        }
    }

    public static TabColumn getFromSlot(MCPlayer player, Integer slot) {
        if (player.getVersion().isLowerThan(MCVersion.of(8))) {
            return Arrays.stream(TabColumn.values()).filter(tabColumn -> tabColumn.getNumbers().contains(slot)).findFirst().get();
        }
        if (TabColumn.isBetween(slot, 1, 20)) {
            return LEFT;
        }
        if (TabColumn.isBetween(slot, 21, 40)) {
            return MIDDLE;
        }
        if (TabColumn.isBetween(slot, 41, 60)) {
            return RIGHT;
        }
        if (TabColumn.isBetween(slot, 61, 80)) {
            return FAR_RIGHT;
        }
        return null;
    }

    public int getNumber(MCPlayer player, int raw) {
        if (player.getVersion().isHigherOrEqual(MCVersion.of(8))) {
            return raw - this.startNumber + 1;
        }
        int number = 0;
        for (int integer : this.numbers) {
            ++number;
            if (integer != raw) continue;
            return number;
        }
        return number;
    }

    public static TabColumn getFromOrdinal(int ordinal) {
        for (TabColumn column : TabColumn.values()) {
            if (column.getOrdinal() != ordinal) continue;
            return column;
        }
        return null;
    }

    private static boolean isBetween(int base, int from, int to) {
        return from <= base && base <= to;
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public int getIncrementBy() {
        return this.incrementBy;
    }

    public int getRawStart() {
        return this.rawStart;
    }

    public List<Integer> getNumbers() {
        return this.numbers;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

