/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.tablist;

import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.tablist.TabColumn;
import info.cho.passwords.fairy.mc.tablist.TabEntry;
import info.cho.passwords.fairy.mc.tablist.TablistSender;
import info.cho.passwords.fairy.mc.tablist.TablistService;
import info.cho.passwords.fairy.mc.tablist.util.Skin;
import info.cho.passwords.fairy.mc.tablist.util.TabSlot;
import info.cho.passwords.fairy.mc.version.MCVersion;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tablist {
    private final MCPlayer player;
    private final TablistService tablistService;
    private final TablistSender tablistSender;
    private final Set<TabEntry> entries = new HashSet<TabEntry>();
    private final AtomicBoolean shown;
    private Component header;
    private Component footer;

    public Tablist(MCPlayer player, TablistService tablistService, TablistSender tablistSender) {
        this.player = player;
        this.tablistService = tablistService;
        this.tablistSender = tablistSender;
        this.shown = new AtomicBoolean(false);
        this.setup();
    }

    private void setup() {
        this.entries.clear();
        int possibleSlots = this.player.getVersion().isLowerThan(MCVersion.of(8)) ? 60 : 80;
        for (int i = 1; i <= possibleSlots; ++i) {
            TabColumn tabColumn = TabColumn.getFromSlot(this.player, i);
            if (tabColumn == null) continue;
            TabEntry tabEntry = new TabEntry(String.format("%03d", i) + "|Tab", UUID.randomUUID(), Component.empty(), this, Skin.GRAY, tabColumn, tabColumn.getNumber(this.player, i), 0);
            this.entries.add(tabEntry);
        }
    }

    private void show() {
        if (!this.shown.compareAndSet(false, true)) {
            return;
        }
        this.tablistSender.addFakePlayer(this, this.entries);
    }

    private void hide() {
        if (!this.shown.compareAndSet(true, false)) {
            return;
        }
        this.tablistSender.removeFakePlayer(this, this.entries);
        for (TabEntry tabEntry : this.entries) {
            this.tablistSender.updateFakeName(this, tabEntry, Component.empty());
            this.tablistSender.updateFakeLatency(this, tabEntry, 0);
            this.tablistSender.updateFakeSkin(this, tabEntry, Skin.GRAY);
        }
        this.header = null;
        this.footer = null;
        this.tablistSender.updateHeaderAndFooter(this, Component.empty(), Component.empty());
    }

    public void update() {
        HashSet<TabEntry> previous = new HashSet<TabEntry>(this.entries);
        Set<TabSlot> current = this.tablistService.getSlots(this.player);
        if (current == null || current.isEmpty()) {
            this.hide();
            return;
        }
        this.show();
        for (TabSlot tabSlot : current) {
            TabEntry tabEntry = this.getEntry(tabSlot.getColumn(), tabSlot.getSlot());
            if (tabEntry == null) continue;
            previous.remove(tabEntry);
            this.tablistSender.updateFakeLatency(this, tabEntry, tabSlot.getPing());
            this.tablistSender.updateFakeName(this, tabEntry, tabSlot.getText());
            this.tablistSender.updateFakeSkin(this, tabEntry, tabSlot.getSkin());
        }
        for (TabEntry tabEntry : previous) {
            this.tablistSender.updateFakeName(this, tabEntry, Component.empty());
            this.tablistSender.updateFakeLatency(this, tabEntry, 0);
            this.tablistSender.updateFakeSkin(this, tabEntry, Skin.GRAY);
        }
        previous.clear();
        Component headerNow = this.tablistService.getHeader(this.player);
        Component footerNow = this.tablistService.getFooter(this.player);
        if (!Objects.equals(this.header, headerNow) || !Objects.equals(this.footer, footerNow)) {
            this.tablistSender.updateHeaderAndFooter(this, headerNow, footerNow);
            this.header = headerNow;
            this.footer = footerNow;
        }
    }

    public TabEntry getEntry(TabColumn column, int slot) {
        for (TabEntry entry : this.entries) {
            if (entry.getColumn() != column || entry.getSlot() != slot) continue;
            return entry;
        }
        throw new IllegalArgumentException("No entry found for column " + (Object)((Object)column) + " and slot " + slot);
    }

    public MCPlayer getPlayer() {
        return this.player;
    }

    public TablistService getTablistService() {
        return this.tablistService;
    }

    public TablistSender getTablistSender() {
        return this.tablistSender;
    }

    public Set<TabEntry> getEntries() {
        return this.entries;
    }

    public AtomicBoolean getShown() {
        return this.shown;
    }

    public Component getHeader() {
        return this.header;
    }

    public Component getFooter() {
        return this.footer;
    }
}

