/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.tablist;

import info.cho.passwords.fairy.container.ContainerContext;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PostInitialize;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.container.collection.ContainerObjCollector;
import info.cho.passwords.fairy.event.Subscribe;
import info.cho.passwords.fairy.libs.kyori.adventure.text.Component;
import info.cho.passwords.fairy.mc.MCPlayer;
import info.cho.passwords.fairy.mc.event.MCPlayerJoinEvent;
import info.cho.passwords.fairy.mc.event.MCPlayerQuitEvent;
import info.cho.passwords.fairy.mc.registry.player.MCPlayerRegistry;
import info.cho.passwords.fairy.mc.scheduler.MCSchedulerProvider;
import info.cho.passwords.fairy.mc.tablist.Tablist;
import info.cho.passwords.fairy.mc.tablist.TablistAdapter;
import info.cho.passwords.fairy.mc.tablist.TablistSender;
import info.cho.passwords.fairy.mc.tablist.util.TabSlot;
import info.cho.passwords.fairy.metadata.MetadataKey;
import info.cho.passwords.fairy.util.Stacktrace;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.jetbrains.annotations.Nullable;

@InjectableComponent
public class TablistService {
    private static final MetadataKey<Tablist> TABLIST_KEY = MetadataKey.create("fairy:TabList", Tablist.class);
    public static TablistService INSTANCE;
    private final TablistSender tablistSender = new TablistSender();
    private final List<TablistAdapter> adapters = new ArrayList<TablistAdapter>();
    private final ContainerContext containerContext;
    private final MCPlayerRegistry mcPlayerRegistry;
    private final MCSchedulerProvider mcSchedulerProvider;
    private ScheduledExecutorService thread;
    private long ticks = 20L;

    @PreInitialize
    public void onPreInitialize() {
        INSTANCE = this;
        this.containerContext.objectCollectorRegistry().add(ContainerObjCollector.create().withFilter(ContainerObjCollector.inherits(TablistAdapter.class)).withAddHandler(ContainerObjCollector.warpInstance(TablistAdapter.class, this::registerAdapter)).withRemoveHandler(ContainerObjCollector.warpInstance(TablistAdapter.class, this::unregisterAdapter)));
    }

    @PostInitialize
    public void onPostInitialize() {
        this.setup();
    }

    public void registerAdapter(TablistAdapter adapter) {
        this.adapters.add(adapter);
        this.adapters.sort((a, b) -> b.priority() - a.priority());
    }

    public void unregisterAdapter(TablistAdapter adapter) {
        this.adapters.remove(adapter);
    }

    @Nullable
    public Set<TabSlot> getSlots(MCPlayer mcPlayer) {
        for (TablistAdapter adapter : this.adapters) {
            Set<TabSlot> slots = adapter.getSlots(mcPlayer);
            if (slots == null) continue;
            return slots;
        }
        return null;
    }

    @Nullable
    public Component getHeader(MCPlayer mcPlayer) {
        for (TablistAdapter adapter : this.adapters) {
            Component header = adapter.getHeader(mcPlayer);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    @Nullable
    public Component getFooter(MCPlayer mcPlayer) {
        for (TablistAdapter adapter : this.adapters) {
            Component footer = adapter.getFooter(mcPlayer);
            if (footer == null) continue;
            return footer;
        }
        return null;
    }

    @Subscribe
    public void onPlayerJoin(MCPlayerJoinEvent event) {
        this.registerPlayerTablist(event.getPlayer());
    }

    @Subscribe
    public void onPlayerQuit(MCPlayerQuitEvent event) {
        this.removePlayerTablist(event.getPlayer());
    }

    public void registerPlayerTablist(MCPlayer player) {
        Tablist tablist = new Tablist(player, this, this.tablistSender);
        player.metadata().put(TABLIST_KEY, tablist);
    }

    public void removePlayerTablist(MCPlayer player) {
        player.metadata().remove(TABLIST_KEY);
    }

    private void setup() {
        this.mcSchedulerProvider.getAsyncScheduler().scheduleAtFixedRate(() -> {
            if (this.adapters.isEmpty()) {
                return;
            }
            for (MCPlayer player : this.mcPlayerRegistry.getAllPlayers()) {
                player.metadata().ifPresent(TABLIST_KEY, tablist -> {
                    try {
                        tablist.update();
                    }
                    catch (Throwable throwable) {
                        Stacktrace.print(throwable);
                    }
                });
            }
        }, this.ticks, this.ticks);
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.shutdown();
            this.thread = null;
        }
    }

    public TablistSender getTablistSender() {
        return this.tablistSender;
    }

    public List<TablistAdapter> getAdapters() {
        return this.adapters;
    }

    public ContainerContext getContainerContext() {
        return this.containerContext;
    }

    public MCPlayerRegistry getMcPlayerRegistry() {
        return this.mcPlayerRegistry;
    }

    public MCSchedulerProvider getMcSchedulerProvider() {
        return this.mcSchedulerProvider;
    }

    public ScheduledExecutorService getThread() {
        return this.thread;
    }

    public long getTicks() {
        return this.ticks;
    }

    public TablistService(ContainerContext containerContext, MCPlayerRegistry mcPlayerRegistry, MCSchedulerProvider mcSchedulerProvider) {
        this.containerContext = containerContext;
        this.mcPlayerRegistry = mcPlayerRegistry;
        this.mcSchedulerProvider = mcSchedulerProvider;
    }

    public void setTicks(long ticks) {
        this.ticks = ticks;
    }
}

