/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.version;

import info.cho.passwords.fairy.Debug;
import info.cho.passwords.fairy.container.InjectableComponent;
import info.cho.passwords.fairy.container.PreInitialize;
import info.cho.passwords.fairy.libs.gson.Gson;
import info.cho.passwords.fairy.libs.gson.JsonArray;
import info.cho.passwords.fairy.libs.gson.JsonElement;
import info.cho.passwords.fairy.libs.gson.JsonObject;
import info.cho.passwords.fairy.log.Log;
import info.cho.passwords.fairy.mc.util.VersionFormatUtil;
import info.cho.passwords.fairy.mc.version.MCVersion;
import info.cho.passwords.fairy.mc.version.MCVersionMapping;
import info.cho.passwords.fairy.mc.version.cache.MCVersionMappingCache;
import info.cho.passwords.fairy.mc.version.cache.MCVersionMappingCacheImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

@InjectableComponent
public class MCVersionMappingRegistry {
    private static final MCVersion LATEST_VERSION = MCVersion.of(1, 21, 0);
    private final Gson gson = new Gson();
    private final MCVersionMappingCache cache = new MCVersionMappingCacheImpl(this.gson);
    private final Map<Integer, MCVersionMapping> mappingByVersion = new HashMap<Integer, MCVersionMapping>();
    private final Map<Integer, MCVersionMapping> mappingByProtocol = new HashMap<Integer, MCVersionMapping>();
    private final TreeSet<Integer> versions = new TreeSet();

    @PreInitialize
    public void onPreInitialize() throws IOException {
        try {
            JsonArray jsonElements = this.cache.read();
            if (jsonElements == null) {
                Log.info("Cached version mappings not found, loading...", new Object[0]);
                jsonElements = this.loadAndWrite();
            }
            this.readAll(jsonElements);
            if (!this.isCacheValid()) {
                Log.info("Cached version mappings are outdated, reloading...", new Object[0]);
                jsonElements = this.loadAndWrite();
                this.readAll(jsonElements);
                if (!this.isCacheValid()) {
                    Log.error("Failed to load version mappings...", new Object[0]);
                } else {
                    Log.info("Cached version mappings loaded successfully!", new Object[0]);
                }
            } else {
                Log.info("Version mappings loaded successfully!", new Object[0]);
            }
        }
        catch (IOException e) {
            Log.error("Failed to load version mappings...", e, new Object[0]);
        }
    }

    @NotNull
    private JsonArray loadAndWrite() throws IOException {
        JsonArray jsonElements = this.cache.load();
        if (!Debug.UNIT_TEST) {
            this.cache.write(jsonElements);
        }
        return jsonElements;
    }

    private void readAll(JsonArray jsonElements) {
        for (JsonElement jsonElement : jsonElements) {
            JsonObject object = jsonElement.getAsJsonObject();
            this.loadVersionFromMinecraftData(object);
        }
    }

    protected boolean isCacheValid() {
        MCVersionMapping mapping = this.findMapping(LATEST_VERSION);
        return mapping != null;
    }

    public MCVersionMapping findMapping(int major, int minor, int patch) {
        int key = VersionFormatUtil.versionToInt(major, minor, patch);
        Integer matchKey = this.versions.floor(key);
        if (matchKey == null) {
            throw new IllegalArgumentException("No mapping found for version " + major + "." + minor + "." + patch);
        }
        return this.mappingByVersion.get(matchKey);
    }

    public MCVersionMapping findMapping(MCVersion mcVersion) {
        return this.findMapping(mcVersion.getMajor(), mcVersion.getMinor(), mcVersion.getPatch());
    }

    public MCVersionMapping findMappingByProtocol(int protocolVersion) {
        return this.mappingByProtocol.get(protocolVersion);
    }

    protected void register(MCVersionMapping mapping) {
        int version = VersionFormatUtil.versionToInt(mapping.getMajor(), mapping.getMinor(), mapping.getPatch());
        this.mappingByVersion.put(version, mapping);
        this.mappingByProtocol.put(mapping.getProtocolVersion(), mapping);
        this.versions.add(version);
    }

    protected void loadVersionFromMinecraftData(JsonObject object) {
        String minecraftVersion = object.get("minecraftVersion").getAsString();
        if (!minecraftVersion.matches("\\d+\\.\\d+(\\.\\d+)?")) {
            return;
        }
        int protocolVersion = object.get("version").getAsInt();
        int[] ints = VersionFormatUtil.splitVersionStringToMajorMinorPatch(minecraftVersion);
        int major = ints[0];
        int minor = ints[1];
        int patch = ints[2];
        boolean hexColor = major >= 1 && minor >= 16;
        boolean nmsPrefix = major < 1 || minor < 17;
        this.register(new MCVersionMapping(major, minor, patch, nmsPrefix, hexColor, protocolVersion));
    }

    public MCVersionMappingCache getCache() {
        return this.cache;
    }
}

