/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.mc.version.impl;

import info.cho.passwords.fairy.mc.version.MCVersion;
import info.cho.passwords.fairy.util.ConditionUtils;
import org.jetbrains.annotations.NotNull;

public class MCVersionImpl
implements MCVersion {
    private final int major;
    private final int minor;
    private final int patch;

    @Override
    public String getFormatted() {
        if (this.patch > 0) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public boolean isHigherThan(MCVersion version) {
        return this.compareTo(version) > 0;
    }

    @Override
    public boolean isHigherOrEqual(MCVersion version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public boolean isLowerThan(MCVersion version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public boolean isLowerOrEqual(MCVersion version) {
        return this.compareTo(version) <= 0;
    }

    @Override
    public boolean isEqual(MCVersion version) {
        return this.compareTo(version) == 0;
    }

    @Override
    public boolean isBetween(MCVersion lower, MCVersion higher) {
        ConditionUtils.not(lower.isHigherThan(higher), "Lower version cannot be higher than higher version");
        return this.isHigherThan(lower) && this.isLowerThan(higher);
    }

    @Override
    public boolean isBetweenOrEqual(MCVersion lower, MCVersion higher) {
        ConditionUtils.not(lower.isHigherThan(higher), "Lower version cannot be higher than higher version");
        return this.isHigherOrEqual(lower) && this.isLowerOrEqual(higher);
    }

    @Override
    public int compareTo(@NotNull MCVersion mcVersion) {
        if (this.getMajor() != mcVersion.getMajor()) {
            return Integer.compare(this.getMajor(), mcVersion.getMajor());
        }
        if (this.getMinor() != mcVersion.getMinor()) {
            return Integer.compare(this.getMinor(), mcVersion.getMinor());
        }
        return Integer.compare(this.getPatch(), mcVersion.getPatch());
    }

    public MCVersionImpl(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MCVersionImpl)) {
            return false;
        }
        MCVersionImpl other = (MCVersionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        return this.getPatch() == other.getPatch();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MCVersionImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMajor();
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getPatch();
        return result;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public int getPatch() {
        return this.patch;
    }
}

