/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.metadata;

import info.cho.passwords.fairy.metadata.MetadataMap;
import info.cho.passwords.fairy.metadata.MetadataRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class AbstractMetadataRegistry<T>
implements MetadataRegistry<T> {
    private final Map<T, MetadataMap> cache = new ConcurrentHashMap<T, MetadataMap>();

    @Override
    public Map<T, MetadataMap> cache() {
        return this.cache;
    }

    @Override
    @NotNull
    public MetadataMap provide(@NotNull T id) {
        Objects.requireNonNull(id, "id");
        return this.cache.computeIfAbsent(id, k -> MetadataMap.create());
    }

    @Override
    @NotNull
    public Optional<MetadataMap> get(@NotNull T id) {
        Objects.requireNonNull(id, "id");
        return Optional.ofNullable(this.cache.get(id));
    }

    @Override
    public void remove(@NotNull T id) {
        MetadataMap map = this.cache.remove(id);
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public void cleanup() {
        this.cache.values().removeIf(MetadataMap::isEmpty);
    }

    @Override
    public void destroy() {
        this.cache.values().forEach(MetadataMap::clear);
        this.cache.clear();
    }
}

