/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.reflect;

import info.cho.passwords.fairy.reflect.ImanityReflectException;
import info.cho.passwords.fairy.reflect.ReflectQuery;
import info.cho.passwords.fairy.util.AccessUtil;
import info.cho.passwords.fairy.util.Utility;
import info.cho.passwords.fairy.util.exceptionally.ThrowingSupplier;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectCache {
    private static final Map<Class<?>, ReflectCache> CLASS_ACCESSORS = new ConcurrentHashMap();
    private final Class<?> parentClass;
    private final Map<ReflectQuery, Method> methodCache;
    private final Map<ReflectQuery, Field> fieldCache;

    public static ReflectCache get(Class<?> parentClass) {
        return ThrowingSupplier.sneaky(() -> CLASS_ACCESSORS.computeIfAbsent(parentClass, ReflectCache::new)).get();
    }

    public ReflectCache(Class<?> parentClass) {
        this.parentClass = parentClass;
        this.methodCache = new ConcurrentHashMap<ReflectQuery, Method>();
        this.fieldCache = new ConcurrentHashMap<ReflectQuery, Field>();
    }

    public Method resolveMethod(ReflectQuery query) {
        if (this.methodCache.containsKey(query)) {
            return this.methodCache.get(query);
        }
        int currentIndex = 0;
        Method result = null;
        Method[] toSearch = query.getModifier() == -1 ? this.parentClass.getDeclaredMethods() : (Method[])Arrays.stream(this.parentClass.getDeclaredMethods()).filter(field -> (field.getModifiers() & query.getModifier()) == 0).toArray(Method[]::new);
        for (Method method : toSearch) {
            if (query.getReturnType() != null && !Utility.wrapPrimitive(query.getReturnType()).equals(Utility.wrapPrimitive(method.getReturnType())) || query.getName() != null && !method.getName().equals(query.getName()) || query.getTypes() != null && query.getTypes().length > 0 && !Utility.isParametersEquals(method.getParameterTypes(), query.getTypes())) continue;
            if (query.getIndex() == -2) {
                result = method;
                continue;
            }
            if (query.getIndex() >= 0 && query.getIndex() != currentIndex++) continue;
            try {
                return this.cache(query, method);
            }
            catch (ReflectiveOperationException ex) {
                throw new ImanityReflectException("Unable to set accessible", ex);
            }
        }
        if (result != null) {
            try {
                return this.cache(query, result);
            }
            catch (ReflectiveOperationException ex) {
                throw new ImanityReflectException("Unable to set accessible", ex);
            }
        }
        throw new ImanityReflectException("No Such Method " + query.toString());
    }

    public Field resolveField(ReflectQuery query) {
        if (this.fieldCache.containsKey(query)) {
            return this.fieldCache.get(query);
        }
        int currentIndex = 0;
        Field result = null;
        Field[] toSearch = query.getModifier() == -1 ? this.parentClass.getDeclaredFields() : (Field[])Arrays.stream(this.parentClass.getDeclaredFields()).filter(field -> (field.getModifiers() & query.getModifier()) == 0).toArray(Field[]::new);
        for (Field field2 : toSearch) {
            Type[] genericTypes;
            if (query.getName() != null && !field2.getName().equals(query.getName()) || query.getReturnType() != null && !Utility.wrapPrimitive(query.getReturnType()).equals(Utility.wrapPrimitive(field2.getType())) || query.getTypes() != null && query.getTypes().length > 0 && ((genericTypes = Utility.getGenericTypes(field2)) == null || !Utility.isParametersEquals(genericTypes, query.getTypes()))) continue;
            if (query.getIndex() == -2) {
                result = field2;
                continue;
            }
            if (query.getIndex() >= 0 && query.getIndex() != currentIndex++) continue;
            try {
                return this.cache(query, field2);
            }
            catch (ReflectiveOperationException ex) {
                throw new ImanityReflectException("Unable to set accessible", ex);
            }
        }
        if (result != null) {
            try {
                return this.cache(query, result);
            }
            catch (ReflectiveOperationException ex) {
                throw new ImanityReflectException("Unable to set accessible", ex);
            }
        }
        throw new ImanityReflectException("No Such Field " + query.toString());
    }

    private Method cache(ReflectQuery query, Method method) throws ReflectiveOperationException {
        AccessUtil.setAccessible(method);
        this.methodCache.put(query, method);
        return method;
    }

    private Field cache(ReflectQuery query, Field field) throws ReflectiveOperationException {
        AccessUtil.setAccessible(field);
        this.fieldCache.put(query, field);
        return field;
    }
}

