/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.reflect;

import info.cho.passwords.fairy.reflect.ImanityReflectException;
import info.cho.passwords.fairy.reflect.ReflectCache;
import info.cho.passwords.fairy.reflect.ReflectQuery;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ReflectObject {
    private final ReflectCache accessorCache;
    private final Class<?> type;
    private Object instance;

    public ReflectObject(Object instance) {
        this(instance.getClass());
        this.instance(instance);
    }

    public ReflectObject(Class<?> type) {
        this.type = type;
        this.accessorCache = ReflectCache.get(type);
    }

    public ReflectObject instance(Object instance) {
        this.instance = instance;
        return this;
    }

    public <T> T get(Class<T> type, int index) {
        Object obj;
        Field field = this.accessorCache.resolveField(new ReflectQuery(type, index));
        try {
            obj = field.get(this.instance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + field.getName(), e);
        }
        return obj != null ? (T)type.cast(obj) : null;
    }

    public <T> T get(String name) {
        Object obj;
        Field field = this.accessorCache.resolveField(new ReflectQuery(name));
        try {
            obj = field.get(this.instance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + field.getName(), e);
        }
        return (T)(obj != null ? obj : null);
    }

    public void set(Class<?> type, int index, Object value) {
        Field field = this.accessorCache.resolveField(new ReflectQuery(type, index));
        try {
            field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + field.getName(), e);
        }
    }

    public void set(String name, Object value) {
        Field field = this.accessorCache.resolveField(new ReflectQuery(name));
        try {
            field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + field.getName(), e);
        }
    }

    public <T> T invoke(String name, Object ... parameters) {
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        Method method = this.accessorCache.resolveMethod(new ReflectQuery(name, types));
        try {
            Object result = method.invoke(this.instance, parameters);
            return (T)(result != null ? result : null);
        }
        catch (ReflectiveOperationException ex) {
            throw new ImanityReflectException(ex);
        }
    }

    public ReflectCache getAccessorCache() {
        return this.accessorCache;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getInstance() {
        return this.instance;
    }
}

