/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.reflect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class ReflectQuery {
    private String name;
    private int index = -1;
    private Class<?> returnType;
    private Class<?>[] types;
    private int modifier = -1;

    public ReflectQuery(Class<?> returnType, String name, int index, Class<?> ... types) {
        this.returnType = returnType;
        this.index = index;
        this.name = name;
        this.types = types;
    }

    public ReflectQuery(Class<?> returnType, int index, Class<?> ... types) {
        this.returnType = returnType;
        this.index = index;
        this.types = types;
    }

    public ReflectQuery(int index, Class<?> ... types) {
        this.index = index;
        this.types = types;
    }

    public ReflectQuery(Class<?> returnType, int index) {
        this.returnType = returnType;
        this.index = index;
        this.types = new Class[0];
    }

    public ReflectQuery(Class<?> returnType, String name, Class<?> ... types) {
        this.returnType = returnType;
        this.name = name;
        this.types = types;
    }

    public ReflectQuery(String name, Class<?> ... types) {
        this.name = name;
        this.types = types;
    }

    public ReflectQuery(String name) {
        this.name = name;
        this.types = new Class[0];
    }

    public ReflectQuery(Class<?> ... types) {
        this.types = types;
    }

    public ReflectQuery modifier(int modifier) {
        this.modifier |= modifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReflectQuery that = (ReflectQuery)o;
        if (this.index != that.index) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(that.returnType) : that.returnType != null) {
            return false;
        }
        if (!Arrays.equals(this.types, that.types)) {
            return false;
        }
        return this.modifier == that.getModifier();
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.index;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.types);
        result = 31 * result + this.modifier;
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", ReflectQuery.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("index=" + this.index).add("returnType=" + this.returnType).add("types=" + Arrays.toString(this.types)).add("modifier=" + this.modifier).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public int getModifier() {
        return this.modifier;
    }

    public static class Builder {
        private final List<ReflectQuery> queryList = new ArrayList<ReflectQuery>();

        private Builder() {
        }

        public Builder with(Class<?> returnType, String name, int index, Class<?>[] types) {
            this.queryList.add(new ReflectQuery(returnType, name, index, types));
            return this;
        }

        public Builder with(Class<?> returnType, int index, Class<?>[] types) {
            this.queryList.add(new ReflectQuery(returnType, index, types));
            return this;
        }

        public Builder with(int index, Class<?>[] types) {
            this.queryList.add(new ReflectQuery(index, types));
            return this;
        }

        public Builder with(Class<?> returnType, int index) {
            this.queryList.add(new ReflectQuery(returnType, index));
            return this;
        }

        public Builder with(Class<?> returnType, String name, Class<?>[] types) {
            this.queryList.add(new ReflectQuery(returnType, name, types));
            return this;
        }

        public Builder with(String name, Class<?>[] types) {
            this.queryList.add(new ReflectQuery(name, types));
            return this;
        }

        public Builder with(String name) {
            this.queryList.add(new ReflectQuery(name));
            return this;
        }

        public Builder with(Class<?>[] types) {
            this.queryList.add(new ReflectQuery(types));
            return this;
        }

        public ReflectQuery[] build() {
            return this.queryList.toArray(new ReflectQuery[0]);
        }
    }
}

