/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state.impl;

import info.cho.passwords.fairy.event.EventNode;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateConfig;
import info.cho.passwords.fairy.state.StateHandler;
import info.cho.passwords.fairy.state.StateMachine;
import info.cho.passwords.fairy.state.event.StateEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StateConfigImpl
implements StateConfig {
    private final State state;
    @NotNull
    private final StateMachine stateMachine;
    private final StateHandler[] handlers;
    private final EventNode<StateEvent> eventNode;

    public StateConfigImpl(@NotNull State state, @NotNull StateMachine stateMachine, @NotNull List<StateHandler> handlers, @NotNull EventNode<StateEvent> eventNode) {
        this.state = state;
        this.stateMachine = stateMachine;
        this.handlers = handlers.toArray(new StateHandler[0]);
        this.eventNode = eventNode;
    }

    @Override
    @NotNull
    public EventNode<StateEvent> getEventNode() {
        return this.eventNode;
    }

    @Override
    @NotNull
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    @NotNull
    public StateHandler[] getHandlers() {
        return this.handlers;
    }

    @Override
    @Nullable
    public StateHandler getHandler(@NotNull Class<? extends StateHandler> handlerClass) {
        for (StateHandler handler : this.handlers) {
            if (!handler.getClass().equals(handlerClass)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public State getState() {
        return this.state;
    }
}

