/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.state.impl;

import info.cho.passwords.fairy.state.Signal;
import info.cho.passwords.fairy.state.State;
import info.cho.passwords.fairy.state.StateMachine;
import info.cho.passwords.fairy.state.Transition;
import info.cho.passwords.fairy.state.TransitionBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class TransitionBuilderImpl
implements TransitionBuilder {
    private final Map<Signal, TransitionBuilder.TransitionHandle> transitions = new HashMap<Signal, TransitionBuilder.TransitionHandle>();

    @Override
    @NotNull
    public TransitionBuilder.TransitionHandle when(@NotNull Signal signal) {
        return this.transitions.computeIfAbsent(signal, TransitionHandleImpl::new);
    }

    @Override
    @NotNull
    public TransitionBuilder when(@NotNull Signal signal, @NotNull Consumer<TransitionBuilder.TransitionHandle> handle) {
        handle.accept(this.when(signal));
        return this;
    }

    @Override
    @NotNull
    public TransitionBuilder when(@NotNull Signal signal, @NotNull TransitionBuilder.TransitionHandle handle) {
        this.transitions.put(signal, handle);
        return this;
    }

    @Override
    @NotNull
    public TransitionBuilder when(@NotNull Signal signal, @NotNull Runnable runnable) {
        this.when(signal).run(runnable);
        return this;
    }

    public Transition build(StateMachine stateMachine) {
        return signal -> {
            TransitionHandleImpl handle = this.transitions.getOrDefault(signal, null);
            if (handle != null) {
                handle.callback.accept(stateMachine, signal);
            }
        };
    }

    public static class TransitionHandleImpl
    implements TransitionBuilder.TransitionHandle {
        private final Signal signal;
        private BiConsumer<StateMachine, Signal> callback;

        public TransitionHandleImpl(Signal signal) {
            this.signal = signal;
        }

        @Override
        @NotNull
        public TransitionBuilder.TransitionHandle to(@NotNull State state) {
            this.callback = (stateMachine, signal) -> stateMachine.transform(state, (Signal)signal);
            return this;
        }

        @Override
        @NotNull
        public TransitionBuilder.TransitionHandle to(@NotNull String state) {
            return this.to(State.of(state));
        }

        @Override
        @NotNull
        public TransitionBuilder.TransitionHandle run(@NotNull Runnable runnable) {
            this.callback = (stateMachine, signal) -> runnable.run();
            return this;
        }
    }
}

