/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import info.cho.passwords.fairy.scheduler.Schedulers;
import info.cho.passwords.fairy.util.terminable.Terminable;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class Cooldown<T>
implements Terminable {
    private final Map<T, Long> cache;
    private final long defaultCooldown;
    private final Terminable task;
    private Consumer<T> removalListener;

    public Cooldown(long defaultCooldown) {
        this(defaultCooldown, null);
    }

    public Cooldown(long defaultCooldown, Consumer<T> removalListener) {
        this.removalListener = removalListener;
        this.cache = new ConcurrentHashMap<T, Long>();
        this.defaultCooldown = defaultCooldown;
        this.task = Schedulers.IO.scheduleAtFixedRate(() -> {
            long time = System.currentTimeMillis();
            for (Map.Entry<T, Long> entry : this.cache.entrySet()) {
                if (time < entry.getValue()) continue;
                this.cache.remove(entry.getKey());
                this.removalListener.accept(entry.getKey());
            }
        }, Duration.ofMillis(50L), Duration.ofMillis(50L));
    }

    public void removalListener(Consumer<T> consumer) {
        this.removalListener = consumer;
    }

    public void addCooldown(T t, long cooldown) {
        this.cache.put(t, System.currentTimeMillis() + cooldown);
    }

    public void addCooldown(T t) {
        this.addCooldown(t, this.defaultCooldown);
    }

    public long getCooldown(T t) {
        Long value = this.cache.get(t);
        return value != null ? System.currentTimeMillis() - value : -1L;
    }

    public boolean isCooldown(T t) {
        return this.cache.get(t) != null;
    }

    public void removeCooldown(T t) {
        this.cache.remove(t);
    }

    @Override
    public void close() throws Exception {
        this.task.close();
    }

    @Override
    public boolean isClosed() {
        return this.task.isClosed();
    }

    public Map<T, Long> getCache() {
        return this.cache;
    }

    public long getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public Terminable getTask() {
        return this.task;
    }

    public Consumer<T> getRemovalListener() {
        return this.removalListener;
    }
}

