/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import info.cho.passwords.fairy.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiConsumer;

public final class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FileUtil.isSystemWindows() ? (char)47 : (char)92;
    private static final char EXTENSION_SEPARATOR = '.';

    public static File getSelfJar() throws URISyntaxException {
        return new File(FileUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI());
    }

    public static void forEachDirectoryInResources(Class<?> searchBy, String folderName, BiConsumer<String, InputStream> inputStreamConsumer) {
        URI uri;
        ClassLoader classLoader = searchBy.getClassLoader();
        try {
            uri = classLoader.getResource(folderName).toURI();
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (uri.getScheme().contains("jar")) {
            try {
                URL jar = searchBy.getProtectionDomain().getCodeSource().getLocation();
                Path jarFile = Paths.get(jar.toString().substring("file:".length()), new String[0]);
                FileSystem fs = FileSystems.newFileSystem(jarFile, (ClassLoader)null);
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(fs.getPath(folderName, new String[0]));
                directoryStream.forEach(p -> {
                    InputStream inputStream = searchBy.getResourceAsStream(p.toString());
                    inputStreamConsumer.accept(p.getFileName().toString(), inputStream);
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Path path = Paths.get(uri);
        try {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);
            for (Path p2 : directoryStream) {
                FileInputStream inputStream = new FileInputStream(p2.toFile());
                inputStreamConsumer.accept(p2.getFileName().toString(), inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static InputStream getResource(Class target, String filename) {
        try {
            URL url = target.getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file) {
        try {
            String text = new String(IOUtil.readFully(inputStream), StandardCharsets.UTF_8);
            FileWriter fileWriter = new FileWriter(FileUtil.createNewFile(file));
            fileWriter.write(text);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File createNewFile(File file) {
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public static void createNewFileAndPath(File file) {
        if (!file.exists()) {
            File folder;
            String filePath = file.getPath();
            int index = filePath.lastIndexOf(File.separator);
            if (index >= 0 && !(folder = new File(filePath.substring(0, index))).exists()) {
                folder.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = FileUtil.indexOfLastSeparator(fileName);
        return fileName.substring(index + 1);
    }

    public static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getExtension(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            return null;
        }
        int index = FileUtil.indexOfExtension(fileName);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static int indexOfExtension(String fileName) throws IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return -1;
        }
        if (FileUtil.isSystemWindows() && (offset = fileName.indexOf(58, FileUtil.getAdsCriticalOffset(fileName))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparator = FileUtil.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int getAdsCriticalOffset(String fileName) {
        int offset1 = fileName.lastIndexOf(SYSTEM_SEPARATOR);
        int offset2 = fileName.lastIndexOf(OTHER_SEPARATOR);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private FileUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

