/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import java.text.DecimalFormat;

public final class FormatUtil {
    private static final DecimalFormat SINGLE_DIGIT_DECIMAL_FORMAT = new DecimalFormat("0.0");

    public static String formatSingleDigitDecimal(Number number) {
        return SINGLE_DIGIT_DECIMAL_FORMAT.format(number);
    }

    public static String formatToSecondsAndMinutes(int seconds) {
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public static String formatToMinutesAndHours(int seconds) {
        return String.format("%02d:%02d", seconds / 3600, seconds % 3600 / 60);
    }

    public static String formatMillisToMinutesAndHours(long millis) {
        int seconds = (int)Math.ceil((double)millis / 1000.0);
        return String.format("%02d:%02d", seconds / 3600, seconds % 3600 / 60);
    }

    public static String formatMillis(long millis) {
        int seconds = (int)Math.ceil((double)millis / 1000.0);
        return FormatUtil.formatSeconds(seconds);
    }

    public static String formatMillisToSecondWithDecimal(long millis) {
        return SINGLE_DIGIT_DECIMAL_FORMAT.format((double)millis / 1000.0);
    }

    public static String formatSeconds(int seconds) {
        if (seconds >= 3600) {
            return String.format("%02d:%02d:%02d", seconds / 3600, seconds % 3600 / 60, seconds % 60);
        }
        return String.format("%02d:%02d", seconds / 60, seconds % 60);
    }

    public static String getBooleanSymbol(boolean bol) {
        return bol ? "\u00a7a\u221a" : "\u00a7cX";
    }

    public static String formatTimes(long millis) {
        int seconds = (int)Math.ceil((double)millis / 1000.0);
        return seconds >= 3600 ? seconds / 3600 + "h" : (seconds >= 60 ? seconds / 60 + 1 + "m" : seconds + "s");
    }

    private FormatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

