/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class TypeLiteral<T> {
    private final Class<T> type;
    private final TypeLiteral<?>[] parameters;

    public TypeLiteral(Class<T> type, TypeLiteral<?> ... parameters) {
        this.type = type;
        this.parameters = parameters;
    }

    protected TypeLiteral() {
        Type thisType = this.getClass().getGenericSuperclass();
        try {
            Type tp = ((ParameterizedType)thisType).getActualTypeArguments()[0];
            if (tp instanceof ParameterizedType) {
                ParameterizedType ptp = (ParameterizedType)tp;
                this.type = (Class)ptp.getRawType();
                this.parameters = (TypeLiteral[])Arrays.stream(ptp.getActualTypeArguments()).map(TypeLiteral::new).toArray(TypeLiteral[]::new);
            } else {
                this.type = (Class)tp;
                this.parameters = new TypeLiteral[0];
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not compute parameterized type for " + thisType, e);
        }
    }

    private TypeLiteral(Type tp) {
        try {
            if (tp instanceof ParameterizedType) {
                ParameterizedType ptp = (ParameterizedType)tp;
                this.type = (Class)ptp.getRawType();
                this.parameters = (TypeLiteral[])Arrays.stream(ptp.getActualTypeArguments()).map(TypeLiteral::new).toArray(TypeLiteral[]::new);
            } else {
                this.type = (Class)tp;
                this.parameters = new TypeLiteral[0];
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Could not compute parameterized type for " + tp, e);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.type.getSimpleName());
        if (this.parameters.length > 0) {
            buf.append("<").append(this.parameters[0].toString());
            for (int i = 1; i < this.parameters.length; ++i) {
                buf.append(", ").append(this.parameters[i].toString());
            }
            buf.append(">");
        }
        return buf.toString();
    }

    public Class<T> getType() {
        return this.type;
    }

    public TypeLiteral<?>[] getParameters() {
        return this.parameters;
    }
}

