/*
 * Decompiled with CFR 0.152.
 */
package info.cho.passwords.fairy.util.exceptionally;

import info.cho.passwords.fairy.util.exceptionally.CheckedException;
import info.cho.passwords.fairy.util.exceptionally.SneakyThrowUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    default public Function<T, R> unchecked() {
        return ThrowingFunction.unchecked(this);
    }

    public static <T, R> Function<T, Optional<R>> lifted(ThrowingFunction<? super T, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return Optional.ofNullable(function.apply(t));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }

    public static <T, R> Function<T, R> unchecked(ThrowingFunction<? super T, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception e) {
                throw new CheckedException(e);
            }
        };
    }

    public static <T1, R> Function<T1, R> sneaky(ThrowingFunction<? super T1, ? extends R, ?> function) {
        Objects.requireNonNull(function);
        return t -> {
            try {
                return function.apply((Object)t);
            }
            catch (Exception ex) {
                return SneakyThrowUtil.sneakyThrow(ex);
            }
        };
    }

    default public Function<T, Optional<R>> lift() {
        return t -> {
            try {
                return Optional.ofNullable(this.apply(t));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }
}

